<?php /* =======================================================
|                                                              |
|   MiMiMi framework & CMS                                     |
|       Copyright 2022 MiMiMi Community                        |
|           > www.mimimi.software                              |
|       Licensed under CC BY 4                                 |
|           > www.creativecommons.org/licenses/by/4.0          |
|                                                              |
|   --------------------------------------------------------   |
|                                                              |
|   This file is a class for the default application. It is    |
|   the simplest controller (in MVP terminology) and it        |
|   contains a minimum of methods for working with your        |
|   application.                                               |
|                                                              |
|   You must extend this class in your modified version        |
|   of the framework to get a specific type of CMS.            |
|   To do this, look up the RUN() method below and rewrite     |
|   it in that extended class.                                 |
|                                                              |
============================================================= */

    /* =========================================================
    |                                                          |
    |   Check for the existence of main constants              |
    |                                                          |
    |   ----------------------------------------------------   |
    |                                                          |
    |   Note: This action is an insurance mechanism. It is     |
    |         used to make your application work without       |
    |         errors. You can remove this action if you are    |
    |         sure to preserve the integrity of your CMS file  |
    |         composition.                                     |
    |                                                          |
    ========================================================= */

    mimimiCheck();

    /* =========================================================
    |                                                          |
    |   Define the default application class                   |
    |                                                          |
    |   ----------------------------------------------------   |
    |                                                          |
    |   Note: If you modify the framework files, they must     |
    |         be located in a specific folder for the modified |
    |         version (see constant MIMIMI_CMS_FOLDER).        |
    |         And the modified classes must be prefixed with   |
    |         "My". For example MyMimimiApplication.           |
    |                                                          |
    ========================================================= */

    class MimimiApplication {
        protected $cms;

        /* =====================================================
        |                                                      |
        |   Create an instance of the class                    |
        |                                                      |
        |   ------------------------------------------------   |
        |                                                      |
        |   Input parameters:                                  |
        |       $owner = OBJECT = a parent application         |
        |                                                      |
        |   ------------------------------------------------   |
        |                                                      |
        |   Output parameters:                                 |
        |       NONE                                           |
        |                                                      |
        ===================================================== */

        public function __construct ( & $owner = NULL ) {
            $this->cms = $owner
                         ? $owner
                         : $this;
        }

        /* =====================================================
        |                                                      |
        |   Load related module into absent property           |
        |                                                      |
        |   ------------------------------------------------   |
        |                                                      |
        |   Input parameters:                                  |
        |       $property = STRING = name of property          |
        |                                                      |
        |   ------------------------------------------------   |
        |                                                      |
        |   Output parameters:                                 |
        |       OBJECT = created module                        |
        |                                                      |
        ===================================================== */

        public function __get ( $property ) {
            return mimimiCreate($property, $this);
        }

        /* =====================================================
        |                                                      |
        |   Perform some actions required for the page with    |
        |   the current URI                                    |
        |                                                      |
        |   ------------------------------------------------   |
        |                                                      |
        |   Input parameters:                                  |
        |       $param = MIXED = some parameter if you need    |
        |                                                      |
        |   ------------------------------------------------   |
        |                                                      |
        |   Output parameters:                                 |
        |       MIXED = some result if you need                |
        |                                                      |
        ===================================================== */

        public function run ( $param = '' ) {

            /* ---------------------------------
            |                                  |
            |   Maybe the visitor is banned?   |
            |                                  |
            --------------------------------- */

            if ($this->has->ban) {
                $this->ban->run();
            }

            /* ---------------------------------
            |                                  |
            |   Maybe a redirect is needed?    |
            |                                  |
            --------------------------------- */

            if ($this->has->redirect) {
                $this->redirect->run();
            }

            /* ---------------------------------
            |                                  |
            |   Else try to route he by URI    |
            |                                  |
            --------------------------------- */

            $default = 'posts';
            $module = $this->has->router
                      ? $this->router->run($default)
                      : $default;

            /* ---------------------------------
            |                                  |
            |   Try to run the routed module   |
            |                                  |
            --------------------------------- */

            if ($this->has->$module) {
                $this->$module->run();

            /* ---------------------------------
            |                                  |
            |   Else try the Theme module      |
            |                                  |
            --------------------------------- */

            } else if ($this->has->theme) {
                $this->theme->run($module);
            } else {

                /* -----------------------------
                |                              |
                |   Else inform your masters   |
                |                              |
                ----------------------------- */

                $msg = 'ERROR: Neither the ' . ucfirst($module) . ' module nor the Theme module found!';
                if ($this->has->informer) {
                    $this->has->informer->run(
                        array(
                            'subject'  => 'Technical problem on [site]',
                            'message'  => $msg,
                            'email'    => MIMIMI_EMAILS_FOR_WEBMASTER,
                            'sms'      => MIMIMI_PHONES_FOR_WEBMASTER,
                            'telegram' => MIMIMI_TELEGRAMS_FOR_WEBMASTER,
                            'details'  => array(
                                              'File'   => __FILE__,
                                              'Class'  => __CLASS__,
                                              'Method' => __METHOD__
                                          )
                        )
                    );
                }

                /* -----------------------------
                |                              |
                |   Show that error to user    |
                |                              |
                ----------------------------- */

                mimimiStop($msg);
            }
            return TRUE;
        }
    };

    /* =========================================================
    |                                                          |
    |   Block trailing injections                              |
    |                                                          |
    ========================================================= */

    return;