<?php /* =======================================================
|                                                              |
|   MiMiMi framework & CMS                                     |
|       Copyright 2022 MiMiMi Community                        |
|           > www.mimimi.software                              |
|       Licensed under CC BY 4                                 |
|           > www.creativecommons.org/licenses/by/4.0          |
|                                                              |
|   --------------------------------------------------------   |
|                                                              |
|   This file is the basis for other system modules of         |
|   the application.                                           |
|                                                              |
|   --------------------------------------------------------   |
|                                                              |
|   Note: All those modules are children of the class          |
|         declared below. If you create a child module,        |
|         you should INCLUDE this file in that module's        |
|         source code, and then use the following notation     |
|         to declare the child class:                          |
|                                                              |
|         class YourChildClass extends MimimiModule {          |
|             ...                                              |
|         }                                                    |
|                                                              |
|   --------------------------------------------------------   |
|                                                              |
|   Note: Use the following notation to INCLUDE this file:     |
|                                                              |
|         include_once(                                        |
|             dirname(__FILE__) . '/../../' .                  |
|             MIMIMI_CORE_FOLDER .                             |
|             'Module.php'                                     |
|         );                                                   |
|                                                              |
|         Here you directs the path from the current folder    |
|         of your child module to the site's root folder,      |
|         then directs that path to the MIMIMI's core folder   |
|         and this file it contains.                           |
|                                                              |
============================================================= */

    class MimimiModule {
        protected $cms;

        /* =====================================================
        |                                                      |
        |   Create an instance of the class                    |
        |                                                      |
        |   ------------------------------------------------   |
        |                                                      |
        |   Input parameters:                                  |
        |       $owner = OBJECT = a parent application         |
        |                                                      |
        |   ------------------------------------------------   |
        |                                                      |
        |   Output parameters:                                 |
        |       NONE                                           |
        |                                                      |
        ===================================================== */

        public function __construct ( & $owner = NULL ) {
            $this->cms = $owner;
        }

        /* =====================================================
        |                                                      |
        |   Perform some actions required for a basic start    |
        |   of the module                                      |
        |                                                      |
        |   ------------------------------------------------   |
        |                                                      |
        |   Note: A non-basic start is a call to any method    |
        |         other than RUN. If a child class needs       |
        |         a basic start of the module, you should      |
        |         override this method in that class and       |
        |         implement the required algorithm there.      |
        |                                                      |
        |   ------------------------------------------------   |
        |                                                      |
        |   Input parameters:                                  |
        |       $param = MIXED = some parameter if you need    |
        |                                                      |
        |   ------------------------------------------------   |
        |                                                      |
        |   Output parameters:                                 |
        |       MIXED = some result if you need                |
        |                                                      |
        ===================================================== */

        public function run ( $param = '' ) {
            return TRUE;
        }
    };

    /* =========================================================
    |                                                          |
    |   Block trailing injections                              |
    |                                                          |
    ========================================================= */

    return;