<?php /* =======================================================
|                                                              |
|   MiMiMi framework & CMS                                     |
|       Copyright 2022 MiMiMi Community                        |
|           > www.mimimi.software                              |
|       Licensed under CC BY 4                                 |
|           > www.creativecommons.org/licenses/by/4.0          |
|                                                              |
|   --------------------------------------------------------   |
|                                                              |
|   This file is the basis for system DB modules that use      |
|   the database table.                                        |
|                                                              |
|   --------------------------------------------------------   |
|                                                              |
|   Note: All those modules are children of the class          |
|         declared below. If you create a child module,        |
|         you should INCLUDE this file in that module's        |
|         source code, and then use the following notation     |
|         to declare the child class:                          |
|                                                              |
|         class YourChildClass extends MimimiModuleWithTable { |
|             ...                                              |
|         }                                                    |
|                                                              |
|   --------------------------------------------------------   |
|                                                              |
|   Note: Use the following notation to INCLUDE this file:     |
|                                                              |
|         include_once(                                        |
|             dirname(__FILE__) . '/../../' .                  |
|             MIMIMI_CORE_FOLDER .                             |
|             'ModuleWithTable.php'                            |
|         );                                                   |
|                                                              |
|         Here you directs the path from the current folder    |
|         of your child module to the site's root folder,      |
|         then directs that path to the MIMIMI's core folder   |
|         and this file it contains.                           |
|                                                              |
============================================================= */

    /* =========================================================
    |                                                          |
    |   Include the basis for system modules                   |
    |                                                          |
    ========================================================= */

    include_once(
        dirname(__FILE__) . '/../' . MIMIMI_CORE_FOLDER . '/Module.php'
    );

    /* =========================================================
    |                                                          |
    |   Declare the child class                                |
    |                                                          |
    ========================================================= */

    class MimimiModuleWithTable extends MimimiModule {

        /* -------------------------------------
        |                                      |
        |   The module's table details         |
        |                                      |
        ------------------------------------- */

        protected $table        = '';
        protected $tableFields  = array(
                      '`id`  BIGINT  NOT NULL  AUTO_INCREMENT  COMMENT "record identifier"'
                  );
        protected $tableKeys    = array(
                      'PRIMARY KEY (`id`)'
                  );
        protected $tableOptions = array(
                      'ENGINE = MyISAM',
                      'AUTO_INCREMENT = 1',
                      'DEFAULT',
                      'CHARSET = utf8'
                  );

        /* =====================================================
        |                                                      |
        |   Create the module's table                          |
        |                                                      |
        |   ------------------------------------------------   |
        |                                                      |
        |   Input parameters:                                  |
        |       NONE                                           |
        |                                                      |
        |   ------------------------------------------------   |
        |                                                      |
        |   Output parameters:                                 |
        |       TRUE  = if success                             |
        |       FALSE = if failure                             |
        |                                                      |
        ===================================================== */

        protected function createTable () {
            if ($this->cms->has->db) {
                $separator = ',';

                /* -----------------------------
                |                              |
                |   Prepare a query            |
                |                              |
                ----------------------------- */

                $query = 'CREATE TABLE  IF NOT EXISTS  `__' . $this->table . '` (' .
                             implode(
                                $separator,
                                $this->tableFields
                             ) .
                             $separator .
                             implode(
                                 $separator,
                                 $this->tableKeys
                             ) .
                         ') ' . implode(
                                    ' ',
                                    $this->tableOptions
                                );

                /* -----------------------------
                |                              |
                |   Execute it                 |
                |                              |
                ----------------------------- */

                $result = $this->cms->db->query(
                    $query
                );
                return $result != FALSE;
            }
            return FALSE;
        }

        /* =====================================================
        |                                                      |
        |   Remove the module's table                          |
        |                                                      |
        |   ------------------------------------------------   |
        |                                                      |
        |   Input parameters:                                  |
        |       NONE                                           |
        |                                                      |
        |   ------------------------------------------------   |
        |                                                      |
        |   Output parameters:                                 |
        |       TRUE  = if success                             |
        |       FALSE = if failure                             |
        |                                                      |
        ===================================================== */

        protected function deleteTable () {
            if ($this->cms->has->db) {
                $result = $this->cms->db->query(
                    'DROP TABLE  IF EXISTS  `__' . $this->table . '`'
                );
                return $result != FALSE;
            }
            return FALSE;
        }

        /* =====================================================
        |                                                      |
        |   Empty the module's table completely                |
        |                                                      |
        |   ------------------------------------------------   |
        |                                                      |
        |   Input parameters:                                  |
        |       NONE                                           |
        |                                                      |
        |   ------------------------------------------------   |
        |                                                      |
        |   Output parameters:                                 |
        |       TRUE  = if success                             |
        |       FALSE = if failure                             |
        |                                                      |
        ===================================================== */

        protected function clearTable () {
            if ($this->cms->has->db) {
                $result = $this->cms->db->query(
                    'TRUNCATE TABLE  `__' . $this->table . '`'
                );
                return $result != FALSE;
            }
            return FALSE;
        }

        /* =====================================================
        |                                                      |
        |   Append a record to the module's table              |
        |                                                      |
        |   ------------------------------------------------   |
        |                                                      |
        |   Input parameters:                                  |
        |       $params = ARRAY = list of the record values    |
        |                         indexed by the column name   |
        |                                                      |
        |   ------------------------------------------------   |
        |                                                      |
        |   Output parameters:                                 |
        |       TRUE  = if success                             |
        |       FALSE = if failure                             |
        |                                                      |
        ===================================================== */

        protected function addRecord ( $params ) {
            if ($this->cms->has->db) {
                if (is_array($params)) {
                    if (!empty($params)) {

                        /* ---------------------
                        |                      |
                        |   Prepare params     |
                        |                      |
                        --------------------- */

                        $fields = implode(
                            '`, `',
                            array_keys($params)
                        );
                        $markers = implode(
                            ', ',
                            array_fill(0, count($params), '?')
                        );
                        $values = array_values($params);

                        /* ---------------------
                        |                      |
                        |   Execute a query    |
                        |                      |
                        --------------------- */

                        $result = $this->cms->db->query(
                            'INSERT INTO  `__' . $this->table . '` ' .
                            ' ( `' . $fields . '` ) ' .
                            ' VALUES ( ' . $markers . ' )',
                            $values
                        );
                        return $result != FALSE;
                    }
                }
            }
            return FALSE;
        }

        /* =====================================================
        |                                                      |
        |   Update the table's record by its identifier        |
        |                                                      |
        |   ------------------------------------------------   |
        |                                                      |
        |   Input parameters:                                  |
        |       $id     = INTEGER = record identifier          |
        |       $params = ARRAY   = list of the record values  |
        |                           indexed by the column name |
        |                                                      |
        |   ------------------------------------------------   |
        |                                                      |
        |   Output parameters:                                 |
        |       TRUE  = if success                             |
        |       FALSE = if failure                             |
        |                                                      |
        ===================================================== */

        protected function updateRecord ( $id ) {
            if ($this->cms->has->db) {
                if (is_array($params)) {
                    if (!empty($params)) {

                        /* ---------------------
                        |                      |
                        |   Prepare params     |
                        |                      |
                        --------------------- */

                        $fields = implode(
                            '` = ?, `',
                            array_keys($params)
                        );
                        $values = array_values($params);
                        $values[] = $id;

                        /* ---------------------
                        |                      |
                        |   Prepare a query    |
                        |                      |
                        --------------------- */

                        $query = 'UPDATE  `__' . $this->table . '`  ' .
                                 'SET ( `' . $fields . '` = ? )  ' .
                                 'WHERE `id` = ?';

                        /* ---------------------
                        |                      |
                        |   Execute it         |
                        |                      |
                        --------------------- */

                        $result = $this->cms->db->query(
                            $query,
                            $values
                        );
                        return $result != FALSE;
                    }
                }
            }
            return FALSE;
        }

        /* =====================================================
        |                                                      |
        |   Delete the table's records by their identifiers    |
        |                                                      |
        |   ------------------------------------------------   |
        |                                                      |
        |   Input parameters:                                  |
        |       $ids = ARRAY   = list of record identifiers    |
        |              INTEGER = record identifier             |
        |                                                      |
        |   ------------------------------------------------   |
        |                                                      |
        |   Output parameters:                                 |
        |       TRUE  = if success                             |
        |       FALSE = if failure                             |
        |                                                      |
        ===================================================== */

        protected function deleteRecord ( $ids ) {
            if ($this->cms->has->db) {

                /* -----------------------------
                |                              |
                |   Prepare params             |
                |                              |
                ----------------------------- */

                if (!is_array($ids)) {
                    $ids = array($ids);
                }
                $markers = implode(
                    ', ',
                    array_fill(0, count($ids), '?')
                );

                /* -----------------------------
                |                              |
                |   Prepare a query            |
                |                              |
                ----------------------------- */

                $query = 'DELETE ' .
                         'FROM  `__' . $this->table . '`  ' .
                         'WHERE `id` IN ( ' . $markers . ' )';

                /* -----------------------------
                |                              |
                |   Execute it                 |
                |                              |
                ----------------------------- */

                $result = $this->cms->db->query(
                    $query,
                    $ids
                );
                return $result != FALSE;
            }
            return FALSE;
        }
    };

    /* =========================================================
    |                                                          |
    |   Block trailing injections                              |
    |                                                          |
    ========================================================= */

    return;