<?php /* =======================================================
|                                                              |
|   MiMiMi framework & CMS                                     |
|       Copyright 2022 MiMiMi Community                        |
|           > www.mimimi.software                              |
|       Licensed under CC BY 4                                 |
|           > www.creativecommons.org/licenses/by/4.0          |
|                                                              |
|   --------------------------------------------------------   |
|                                                              |
|   This file is the starting point of your website. It just   |
|   loads the default application or its modified version      |
|   and launches that application.                             |
|                                                              |
============================================================= */

    /* =========================================================
    |                                                          |
    |   Define some constants                                  |
    |       > the official version of the framework            |
    |       > where the framework is located                   |
    |       > where is its modules                             |
    |       > where is its modified version                    |
    |       > where is its installer                           |
    |                                                          |
    ========================================================= */

    define('MIMIMI_CORE_VERSION',   '3.0 - 2022.01.27');
    define('MIMIMI_CORE_FOLDER',    'mimimi.core/');
    define('MIMIMI_MODULES_FOLDER', 'mimimi.modules/');
    define('MIMIMI_CMS_FOLDER',     '-mimimi.cms/');
    define('MIMIMI_INSTALL_FOLDER', 'mimimi.install/');

    /* =========================================================
    |                                                          |
    |   Load the configuration                                 |
    |                                                          |
    |   ----------------------------------------------------   |
    |                                                          |
    |   How it works?                                          |
    |                                                          |
    |       > define a loading plan:                           |
    |             Config.php   = configuration constants       |
    |                 MIMIMI_DATABASE_HOST                     |
    |                 MIMIMI_DATABASE_NAME                     |
    |                 MIMIMI_DATABASE_USER                     |
    |                 MIMIMI_DATABASE_PASSWORD                 |
    |                 ...                                      |
    |                 and so on                                |
    |             Routines.php = mini helper routines:         |
    |                 mimimiCheck   = check for constants      |
    |                 mimimiCreate  = create the required obj  |
    |                 mimimiInclude = include a PHP file       |
    |                 mimimiDump    = dump a file              |
    |                 mimimiInform  = inform your masters      |
    |                 mimimiCookie  = retrieve COOKIE param    |
    |                 mimimiEnvironment = retrieve ENV param   |
    |                 mimimiFiles   = retrieve FILES param     |
    |                 mimimiGet     = retrieve GET param       |
    |                 mimimiPost    = retrieve POST param      |
    |                 mimimiRequest = retrieve REQUEST param   |
    |                 mimimiServer  = retrieve SERVER param    |
    |                 mimimiSession = retrieve SESSION param   |
    |                 mimimiStop    = stop execution           |
    |       > enumerate the plan's files                       |
    |           > define a loading locations:                  |
    |                 MIMIMI_INSTALL_FOLDER = see to INSTALLER |
    |                 MIMIMI_CMS_FOLDER     = see to CMS folder|
    |                 MIMIMI_MODULES_FOLDER = ignore MODULES   |
    |                 MIMIMI_CORE_FOLDER    = see to FRAMEWORK |
    |           > enumerate the location's folders             |
    |               > if that planned file exists              |
    |                   > load the file                        |
    |                   > break enumeration                    |
    |               > end if                                   |
    |           > end enumeration                              |
    |       > end enumeration                                  |
    |                                                          |
    ========================================================= */

    $plan = array(
        'Config.php',
        'Routines.php'
    );
    foreach ($plan as $file) {
        $location = array(
            MIMIMI_INSTALL_FOLDER => TRUE,
            MIMIMI_CMS_FOLDER     => TRUE,
            MIMIMI_MODULES_FOLDER => FALSE,
            MIMIMI_CORE_FOLDER    => TRUE
        );
        foreach ($location as $folder => $enabled) {
            if ($enabled) {
                if (file_exists($folder . $file)) {
                    include_once($folder . $file);
                    break;
                }
            }
        }
    }

    /* =========================================================
    |                                                          |
    |   Launch the application                                 |
    |       > define a global variable                         |
    |       > load and create an app (it will become your CMS) |
    |       > run it                                           |
    |                                                          |
    ========================================================= */

    global $cms;
           $cms = mimimiCreate('application');
           $cms->run();

    /* =========================================================
    |                                                          |
    |   Block trailing injections                              |
    |                                                          |
    ========================================================= */

    return;