<?php /* =======================================================
|                                                              |
|   MiMiMi framework & CMS                                     |
|       Copyright 2022 MiMiMi Community                        |
|           > www.mimimi.software                              |
|       Licensed under CC BY 4                                 |
|           > www.creativecommons.org/licenses/by/4.0          |
|                                                              |
|   --------------------------------------------------------   |
|                                                              |
|   This file is a class for the HAS module. It checks for     |
|   the existence of other modules in the specific framework   |
|   folder.                                                    |
|                                                              |
|   --------------------------------------------------------   |
|                                                              |
|   For example, let's check for the "Hello" module:           |
|                                                              |
|       $cms = mimimiCreate('application');                    |
|       if ($cms->has->hello) {                                |
|           $cms->hello->show('I am ../Hello/Hello.php');      |
|       }                                                      |
|                                                              |
============================================================= */

    /* =========================================================
    |                                                          |
    |   Load the basis for system modules from the CORE folder |
    |                                                          |
    ========================================================= */

    mimimiInclude('Module.php');

    /* =========================================================
    |                                                          |
    |   Declare the HAS module's class                         |
    |                                                          |
    ========================================================= */

    class MimimiHas extends MimimiModule {

        /* =====================================================
        |                                                      |
        |   Check for the existence                            |
        |                                                      |
        |   ------------------------------------------------   |
        |                                                      |
        |   Input parameters:                                  |
        |       $property = STRING = name of property          |
        |                                                      |
        |   ------------------------------------------------   |
        |                                                      |
        |   Output parameters:                                 |
        |       BOOLEAN = TRUE if the module exists            |
        |               = FALSE if it is absent                |
        |                                                      |
        ===================================================== */

        public function __get ( $property ) {
            return isset($this->$property)
                   ? FALSE
                   : (
                         isset($this->cms->$property) &&
                         !empty($this->cms->$property) ||
                         mimimiCreate($property, $this->cms, TRUE)
                     );
        }
    };

    /* =========================================================
    |                                                          |
    |   Block trailing injections                              |
    |                                                          |
    ========================================================= */

    return;