<?php /* =======================================================
|                                                              |
|   MiMiMi framework & CMS                                     |
|       Copyright 2022 MiMiMi Community                        |
|           > www.mimimi.software                              |
|       Licensed under CC BY 4                                 |
|           > www.creativecommons.org/licenses/by/4.0          |
|                                                              |
|   --------------------------------------------------------   |
|                                                              |
|   This file is a class for the default application. It is    |
|   the simplest controller (in MVP terminology) and it        |
|   contains a minimum of methods for working with your        |
|   application.                                               |
|                                                              |
|   You must extend this class in your modified version        |
|   of the framework to get a specific type of CMS.            |
|   To do this, look up the RUN method below and rewrite       |
|   it in that extended class.                                 |
|                                                              |
============================================================= */

    /* =========================================================
    |                                                          |
    |   Check for the existence of main constants              |
    |                                                          |
    |   ----------------------------------------------------   |
    |                                                          |
    |   Note: This action is an insurance mechanism. It is     |
    |         used to make your application work without       |
    |         errors. You can remove this action if you are    |
    |         sure to preserve the integrity of your CMS file  |
    |         composition.                                     |
    |                                                          |
    ========================================================= */

    mimimiCheck();

    /* =========================================================
    |                                                          |
    |   Load the basis for system modules from the CORE folder |
    |                                                          |
    ========================================================= */

    mimimiInclude('Module.php');

    /* =========================================================
    |                                                          |
    |   Define the default application class                   |
    |                                                          |
    |   ----------------------------------------------------   |
    |                                                          |
    |   Note: If you modify the framework files, they must     |
    |         be located in a specific folder for the modified |
    |         version (see constant MIMIMI_CMS_FOLDER).        |
    |         And the modified classes must be prefixed with   |
    |         "My". For example MyMimimiApplication.           |
    |                                                          |
    ========================================================= */

    class MimimiApplication extends MimimiModule {

        /* =====================================================
        |                                                      |
        |   Load related module into absent property           |
        |                                                      |
        |   ------------------------------------------------   |
        |                                                      |
        |   Input parameters:                                  |
        |       $property = STRING = name of property          |
        |                                                      |
        |   ------------------------------------------------   |
        |                                                      |
        |   Output parameters:                                 |
        |       OBJECT = created module                        |
        |       FALSE  = if this property exists and it is     |
        |                protected or private                  |
        |                                                      |
        ===================================================== */

        public function __get ( $property ) {
            return isset($this->$property)
                   ? FALSE
                   : mimimiCreate($property, $this);
        }

        /* =====================================================
        |                                                      |
        |   Perform some actions required to render a page     |
        |   with the current URI                               |
        |                                                      |
        |   ------------------------------------------------   |
        |                                                      |
        |   Input parameters:                                  |
        |       $params = MIXED = some parameters if you need  |
        |                                                      |
        |   ------------------------------------------------   |
        |                                                      |
        |   Output parameters:                                 |
        |       MIXED = some result if you need                |
        |                                                      |
        ===================================================== */

        public function run ( $params = '' ) {

            /* ---------------------------------
            |                                  |
            |   Generate some HTML content by  |
            |   template of the home page      |
            |                                  |
            --------------------------------- */

            mimimiModule('home.php', TRUE);
        }
    };

    /* =========================================================
    |                                                          |
    |   Block trailing injections                              |
    |                                                          |
    ========================================================= */

    return;