<?php /* =======================================================
|                                                              |
|   Template to display the page's bottom                      |
|                                                              |
|   --------------------------------------------------------   |
|                                                              |
|   Author: MiMiMi Community                                   |
|       > www.mimimi.software                                  |
|   Licensed under CC BY 4                                     |
|       > www.creativecommons.org/licenses/by/4.0              |
|                                                              |
|   --------------------------------------------------------   |
|                                                              |
|   Input variables:                                           |
|       $folder   = application's folder name (ended with /)   |
|       $filename = this template filepath (relative to the    |
|                   application's folder)                      |
|       $file     = this template's absolute filepath          |
|       $cms      = application's object                       |
|                                                              |
|   --------------------------------------------------------   |
|                                                              |
|   Global variables:                                          |
|       $post = a data of the current page:                    |
|                   'title'    => page title                   |
|                   'meta'     => page description             |
|                   'keywords' => page keywords                |
|                   ...                                        |
|                   and so on                                  |
|                                                              |
============================================================= */

?>      <!-- -----------------------------------
        |                                      |
        |   The page footer                    |
        |                                      |
        ------------------------------------ -->

        <footer>
            <p>&copy; <?php echo date('Y') ?> Installer Example</p>
            <menu>
                <a href="https://mimimi.software/" rel="nofollow">Powered by MiMiMi</a>
                <a href="https://flaticon.com/" rel="nofollow">Icons by FlatIcon</a>
            </menu>
        </footer>

        <!-- -----------------------------------
        |                                      |
        |   Insert the template's javascripts  |
        |                                      |
        ------------------------------------ -->

        <script>
            <?php mimimiDump('js/script.js') ?>
        </script>
    </body>
</html>