<?php /* =======================================================
|                                                              |
|   Template to display the page's form named FORM-3           |
|                                                              |
|   --------------------------------------------------------   |
|                                                              |
|   Author: MiMiMi Community                                   |
|       > www.mimimi.software                                  |
|   Licensed under CC BY 4                                     |
|       > www.creativecommons.org/licenses/by/4.0              |
|                                                              |
|   --------------------------------------------------------   |
|                                                              |
|   Input variables:                                           |
|       $folder   = application's folder name (ended with /)   |
|       $filename = this template filepath (relative to the    |
|                   application's folder)                      |
|       $file     = this template's absolute filepath          |
|       $cms      = application's object                       |
|                                                              |
============================================================= */

    /* -----------------------------------------
    |                                          |
    |   Get the list of module folders         |
    |                                          |
    ----------------------------------------- */

    $list = listCoreModules();

    /* -----------------------------------------
    |                                          |
    |   Make the READONLY/CLICKABLE attribute  |
    |   and the DISABLED/ENABLED class for     |
    |   FLAGS (see them in the HTML layout     |
    |   below, and see the related INPUT 2     |
    |   on the STEP-1 page)                    |
    |                                          |
    ----------------------------------------- */

    $param = getFlashbackPrefix() . 'folderModules';
    $flagAttribute = getSession($param)
                     ? ''
                     : 'disabled';
    $flagClass = $flagAttribute
                 ? 'disabled'
                 : '';

    /* -----------------------------------------
    |                                          |
    |   Define the controlled form fields:     |
    |       name         = a field name        |
    |       value        = its initial value   |
    |       options      = list of values for  |
    |                      tag <select> in     |
    |                      format "Value" or   |
    |                      "Value|To Display"  |
    |       flashback    = TRUE if save the    |
    |                      posted field in     |
    |                      session and restore |
    |                      it on next time     |
    |       corrected    = a list of regular   |
    |                      expressions to      |
    |                      optimize the posted |
    |                      field before        |
    |                      checking for errors |
    |       required     = TRUE if the posted  |
    |                      field cannot be     |
    |                      empty               |
    |       requ..Error  = a message if this   |
    |                      field is empty      |
    |       format       = a regular expression|
    |                      to validate the     |
    |                      posted field        |
    |       formatError  = a message if this   |
    |                      field is incorrect  |
    |       cha..Message = a message if this   |
    |                      field is changed    |
    |       readonly     = TRUE if ignore this |
    |                      field and always use|
    |                      its initial value   |
    |                                          |
    |   ------------------------------------   |
    |                                          |
    |   Note: Define this variable as global   |
    |         to use below (see routines       |
    |         printFormValue, printFormError,  |
    |         and printFormChanges in the      |
    |         HELPER.PHP file).                |
    |                                          |
    ----------------------------------------- */

    global $form;
    $form = array();
    foreach ($list as $item) {
        $form[] = array(
                      'name'      => 'modules' . $item,
                      'value'     => 1,
                      'checkbox'  => TRUE,
                      'flashback' => TRUE
                  );
    }

    /* -----------------------------------------
    |                                          |
    |   Do some backend logic                  |
    |       > restore (flashback) value of     |
    |         the form fields from the session |
    |       > if form is posted                |
    |           > validate posted form if      |
    |             modules are not disabled     |
    |             (see the INPUT 2 on the      |
    |             STEP-1 page)                 |
    |           > if that form is OK           |
    |               > remember that STEP-3 is  |
    |                 passed                   |
    |               > send soft redirect to    |
    |                 the STEP-4 page          |
    |               > return (break this       |
    |                 template)                |
    |           > end if                       |
    |                                          |
    |   ------------------------------------   |
    |                                          |
    |   Note: See the HELPER.PHP file to       |
    |         understand this logic.           |
    |                                          |
    ----------------------------------------- */

    flashbackForm($form);
    if (mimimiPost('submitForm3')) {
        $ok = $flagAttribute
              ? TRUE
              : validateForm($form, 'submitForm3');
        if ($ok) {
            setCheckpoint('step3'); ?>

            <script>
                location.replace('<?php printSiteUri() ?>step-4')
            </script> <?php

            return;
        }

    /* -----------------------------------------
    |                                          |
    |   Do some warning logic                  |
    |       > Otherwise (if it is first visit) |
    |           > if modules are disabled      |
    |               > display a warning        |
    |           > end if                       |
    |       > end if                           |
    |                                          |
    ----------------------------------------- */

    } else {
        if ($flagAttribute) { ?>

            <p class="warning">
                ATTENTION &raquo; You declined the installation of modules
                on the STEP 1 page, so these settings are not available. You can return
                <a href="<?php printSiteUri() ?>step-1">&laquo; to the STEP 1</a>
                or click the NEXT button below to continue.
            </p> <?php
        }
    }

    /* =========================================================
    |                                                          |
    |   Make a content for the user                            |
    |                                                          |
    ========================================================= */

?>  <form action="<?php printPageUri() ?>" method="post">
        <fieldset>
            <legend>
                Modules
            </legend>

            <?php /* ---------------------------
            |                                  |
            |   Show flags                     |
            |                                  |
            --------------------------------- */

                foreach ($list as $item) {
                    $name = 'modules' . $item;
                    $value = getSession(getFlashbackPrefix() . $name, 1); ?>

                    <label class="size33 <?php printValue($flagClass) ?>">
                        <span class="flag">
                            <input name="<?php printValue($name) ?>"
                                   type="checkbox"
                                   value="1"
                                   <?php printValue($flagAttribute) ?>
                                   <?php printValue($value ? ' checked' : '') ?>>
                                   <?php printValue($item) ?>
                        </span>
                    </label> <?php
                }
            ?>
        </fieldset>

        <!-- -----------------------------------
        |                                      |
        |   Pagination if you need             |
        |                                      |
        ------------------------------------ -->

        <nav>
            <a class="btn" href="<?php printSiteUri() ?>step-2">
                &laquo; Back
            </a>
            <button type="submit" name="submitForm3" value="1">
                Next &raquo;
            </button>
        </nav>
    </form>
