<?php /* =======================================================
|                                                              |
|   Template to display the MiMiMi Installer's STEP-5 page     |
|                                                              |
|   --------------------------------------------------------   |
|                                                              |
|   Author: MiMiMi Community                                   |
|       > www.mimimi.software                                  |
|   Licensed under CC BY 4                                     |
|       > www.creativecommons.org/licenses/by/4.0              |
|                                                              |
|   --------------------------------------------------------   |
|                                                              |
|   Input variables:                                           |
|       $folder   = application's folder name (ended with /)   |
|       $filename = this template filepath (relative to the    |
|                   application's folder)                      |
|       $file     = this template's absolute filepath          |
|       $cms      = application's object                       |
|                                                              |
============================================================= */

    /* -----------------------------------------
    |                                          |
    |   Do some backend logic                  |
    |       > load the HELPER file             |
    |       > start the visitor's session      |
    |                                          |
    |   ------------------------------------   |
    |                                          |
    |   Note: See the HELPER.PHP file to       |
    |         understand this logic.           |
    |                                          |
    ----------------------------------------- */

    mimimiModule('helper.php');
    startSession();

    /* -----------------------------------------
    |                                          |
    |   Do some security logic                 |
    |       > if page STEP-5 is not passed     |
    |           > redirect to homepage         |
    |       > end if                           |
    |       > send status "200 OK"             |
    |                                          |
    ----------------------------------------- */

    if (hasNoCheckpoint('step5')) {
        gotoHome();
    }
    sendStatus200();

    /* -----------------------------------------
    |                                          |
    |   Simulate reading a post from database  |
    |                                          |
    ----------------------------------------- */

    global  $post;
            $post = array(
                'title'    => 'Install the MiMiMi - Final',
                'h1'       => 'Installing'
            );

    /* =========================================================
    |                                                          |
    |   Make a content for the user                            |
    |                                                          |
    ========================================================= */

    /* -----------------------------------------
    |                                          |
    |   Display the page's top                 |
    |                                          |
    ----------------------------------------- */

    mimimiModule('blocks/header.php');

?>  <!-- ---------------------------------------
    |                                          |
    |   Display the page's content             |
    |                                          |
    ---------------------------------------- -->

    <main>
        <h1>
            <strong>Final</strong>
            <?php printPageH1() ?>
        </h1> <?php

        /* -------------------------------------
        |                                      |
        |   Do some database logic             |
        |                                      |
        ------------------------------------- */

        $prefix = getFlashbackPrefix();
        if (hasDatabase()) {

            $cms->db->connect(
                array(
                    'driver'    => getSession($prefix . 'databaseDriver'),
                    'host'      => getSession($prefix . 'databaseHost'),
                    'port'      => getSession($prefix . 'databasePort'),
                    'user'      => getSession($prefix . 'databaseUser'),
                    'password'  => getSession($prefix . 'databasePassword'),
                    'name'      => getSession($prefix . 'databaseName'),
                    'charset'   => getSession($prefix . 'databaseCharset'),
                    'collation' => getSession($prefix . 'databaseCollation')
                )
            ); ?>

            <h2>Database</h2>
            <ul> <?php

                $items = listInstallerModules();
                foreach ($items as $name) {
                    $module = strtolower($name);
                    if ($cms->has->$module) { ?>

                        <li>
                            Install a demo records for the
                            <em><?php printValue($name) ?></em>
                            module
                            <?php echo $cms->$module->run() ?>
                        </li> <?php
                    }
                } ?>

            </ul> <?php
        }

        /* -------------------------------------
        |                                      |
        |   Do some installation logic         |
        |                                      |
        ------------------------------------- */

        $modules = listCoreModules();
        $variants = listCmsVariants(); ?>

        <h2>Components</h2>
        <ul>
            <li>
                Install the directory for the Core <?php

                $folder = MIMIMI_CORE_FOLDER;
                $newFolder = getCoreFolder();

                renameDirectory(
                    $folder,
                    $newFolder
                ); ?>

                <p class="success">
                    rename <span>
                               <?php printValue($folder) ?>
                           </span> to the <strong>
                                              <?php printValue($newFolder) ?>
                                          </strong>
                </p>
            </li> <?php

            /* ---------------------------------
            |                                  |
            |   ... for the Core's modules     |
            |                                  |
            --------------------------------- */

            if (hasCoreModules()) { ?>
                <li>
                    Install the directory for the Core's modules <?php

                    $folder = MIMIMI_MODULES_FOLDER;
                    $newFolder = getCoreModulesFolder(); ?>

                    <p class="success">
                        rename <span>
                                   <?php printValue($folder) ?>
                               </span> to the <strong>
                                                  <?php printValue($newFolder) ?>
                                              </strong>
                    </p> <?php

                    foreach ($modules as $module) {
                        if (getSession($prefix . 'modules' . $module)) { ?>

                            <p class="success">
                                install module <span>
                                                   <?php printValue($module) ?>
                                               </span>
                            </p> <?php

                        } else { ?>

                            <p class="remove">
                                remove <span>
                                           <?php printValue(MIMIMI_MODULES_FOLDER . $module) ?>
                                       </span>
                            </p> <?php

                            deleteDirectory(
                                MIMIMI_MODULES_FOLDER . $module
                            );
                        }
                    }

                    renameDirectory(
                        $folder,
                        $newFolder
                    ); ?>
                </li> <?php

            } else { ?>

                <li>
                    Remove the directory for the Core's modules <?php

                    deleteDirectory(
                        MIMIMI_MODULES_FOLDER
                    ); ?>

                    <p class="remove">
                        remove <span>
                                   <?php printValue(MIMIMI_MODULES_FOLDER) ?>
                               </span>
                    </p>
                </li> <?php
            }

            /* ---------------------------------
            |                                  |
            |   ... for the Installer          |
            |                                  |
            --------------------------------- */ ?>

            <li>
                Remove the directory for the Installer <?php

                deleteDirectory(
                    MIMIMI_INSTALL_FOLDER
                ); ?>

                <p class="remove">
                    remove <span>
                               <?php printValue(MIMIMI_INSTALL_FOLDER) ?>
                           </span>
                </p>
            </li> <?php

            /* ---------------------------------
            |                                  |
            |   ... for the CMS                |
            |                                  |
            --------------------------------- */

            if (hasCms()) { ?>

                <li>
                    Install the directory for the CMS <?php

                    $folder = getCmsVariantFolder();
                    $newFolder = getCmsFolder();

                    foreach ($variants as $variant) {
                        if ($variant == $folder) { ?>

                            <p class="success">
                                rename <span>
                                           <?php printValue($folder) ?>
                                       </span> to the <strong>
                                                          <?php printValue($newFolder) ?>
                                                      </strong>
                            </p> <?php

                        } else { ?>

                            <p class="remove">
                                remove <span>
                                           <?php printValue($variant) ?>
                                       </span>
                            </p> <?php

                            deleteDirectory($variant);
                        }
                    }

                    renameDirectory(
                        $folder,
                        $newFolder
                    ); ?>

                </li> <?php

            } else { ?>

                <li>
                    Remove the directory for the CMS <?php

                    foreach ($variants as $variant) { ?>

                        <p class="remove">
                            remove <span>
                                       <?php printValue($variant) ?>
                                   </span>
                        </p> <?php

                        deleteDirectory($variant);
                    } ?>

                </li> <?php
            } ?>

        </ul>

        <!-- -----------------------------------
        |                                      |
        |   ... for constants                  |
        |                                      |
        ------------------------------------ -->

        <h2>Settings</h2>
        <ul>
            <li>CORE folder      <?php updateConstant('MIMIMI_CORE_FOLDER',    'folderCore') ?></li>
            <li>MODULES folder   <?php updateConstant('MIMIMI_MODULES_FOLDER', 'folderModules', MIMIMI_MODULES_FOLDER) ?></li>
            <li>CMS folder       <?php updateConstant('MIMIMI_CMS_FOLDER',     'folderCms',     MIMIMI_CMS_FOLDER) ?></li>
            <li>INSTALLER folder <?php updateConstant('MIMIMI_INSTALL_FOLDER', 'folderInstall', MIMIMI_INSTALL_FOLDER) ?></li>
        </ul>
        <ul>
            <li>CORE theme       <?php updateConstant('MIMIMI_CORE_THEME',    'themeCore',    MIMIMI_CORE_THEME) ?></li>
            <li>CMS theme        <?php updateConstant('MIMIMI_CMS_THEME',     'themeCms',     MIMIMI_CMS_THEME) ?></li>
            <li>INSTALLER theme  <?php updateConstant('MIMIMI_INSTALL_THEME', 'themeInstall', MIMIMI_INSTALL_THEME) ?></li>
        </ul>
        <ul>
            <li>DATABASE driver    <?php updateConstant('MIMIMI_DATABASE_DRIVER',       'databaseDriver') ?></li>
            <li>DATABASE host      <?php updateConstant('MIMIMI_DATABASE_HOST',         'databaseHost') ?></li>
            <li>DATABASE port      <?php updateConstant('MIMIMI_DATABASE_PORT',         'databasePort') ?></li>
            <li>DATABASE user      <?php updateConstant('MIMIMI_DATABASE_USER',         'databaseUser') ?></li>
            <li>DATABASE password  <?php updateConstant('MIMIMI_DATABASE_PASSWORD',     'dummyParameter', '**hidden**') ?></li>
            <li>DATABASE name      <?php updateConstant('MIMIMI_DATABASE_NAME',         'databaseName') ?></li>
            <li>DATABASE prefix    <?php updateConstant('MIMIMI_DATABASE_TABLE_PREFIX', 'databasePrefix') ?></li>
            <li>DATABASE charset   <?php updateConstant('MIMIMI_DATABASE_CHARSET',      'databaseCharset') ?></li>
            <li>DATABASE collation <?php updateConstant('MIMIMI_DATABASE_COLLATION',    'databaseCollation') ?></li>
        </ul>
        <ul>
            <li>WEBMASTER email       <?php updateConstant('MIMIMI_EMAILS_FOR_WEBMASTER',       'notifyEmailsWeb') ?></li>
            <li>CONTENT MASTER email  <?php updateConstant('MIMIMI_EMAILS_FOR_CONTENT_MASTER',  'notifyEmailsContent') ?></li>
            <li>TRAFFIC MASTER email  <?php updateConstant('MIMIMI_EMAILS_FOR_TRAFFIC_MASTER',  'notifyEmailsTraffic') ?></li>
            <li>SECURITY MASTER email <?php updateConstant('MIMIMI_EMAILS_FOR_SECURITY_MASTER', 'notifyEmailsSecurity') ?></li>
        </ul>
        <ul>
            <li>WEBMASTER phone       <?php updateConstant('MIMIMI_PHONES_FOR_WEBMASTER',       'notifyPhonesWeb') ?></li>
            <li>CONTENT MASTER phone  <?php updateConstant('MIMIMI_PHONES_FOR_CONTENT_MASTER',  'notifyPhonesContent') ?></li>
            <li>TRAFFIC MASTER phone  <?php updateConstant('MIMIMI_PHONES_FOR_TRAFFIC_MASTER',  'notifyPhonesTraffic') ?></li>
            <li>SECURITY MASTER phone <?php updateConstant('MIMIMI_PHONES_FOR_SECURITY_MASTER', 'notifyPhonesSecurity') ?></li>
        </ul>
        <ul>
            <li>WEBMASTER telegram       <?php updateConstant('MIMIMI_TELEGRAMS_FOR_WEBMASTER',       'notifyTelegramsWeb') ?></li>
            <li>CONTENT MASTER telegram  <?php updateConstant('MIMIMI_TELEGRAMS_FOR_CONTENT_MASTER',  'notifyTelegramsContent') ?></li>
            <li>TRAFFIC MASTER telegram  <?php updateConstant('MIMIMI_TELEGRAMS_FOR_TRAFFIC_MASTER',  'notifyTelegramsTraffic') ?></li>
            <li>SECURITY MASTER telegram <?php updateConstant('MIMIMI_TELEGRAMS_FOR_SECURITY_MASTER', 'notifyTelegramsSecurity') ?></li>
        </ul> <?php

        /* -------------------------------------
        |                                      |
        |   Do some security logic             |
        |       > remember "HOME is not passed"|
        |       > ... STEP-1 is not passed     |
        |       > ... STEP-2 is not passed     |
        |       > ... STEP-3 is not passed     |
        |       > ... STEP-4 is not passed     |
        |       > ... STEP-5 is not passed     |
        |                                      |
        ------------------------------------- */

        clearCheckpoint('home');
        clearCheckpoint('step1');
        clearCheckpoint('step2');
        clearCheckpoint('step3');
        clearCheckpoint('step4');
        clearCheckpoint('step5'); ?>

        <h2>Installation completed!</h2>

        <!-- -----------------------------------
        |                                      |
        |   Pagination if you need             |
        |                                      |
        ------------------------------------ -->

        <nav>
            <a class="btn" href="<?php printSiteUri() ?>">
                Homepage &raquo;
            </a>
        </nav>
    </main>

<?php /* ---------------------------------------
    |                                          |
    |   Display the page's bottom              |
    |                                          |
    ----------------------------------------- */

    mimimiModule('blocks/footer.php');
