<?php /* =======================================================
|                                                              |
|   Template to display the MiMiMi Installer's STEP-5 page     |
|                                                              |
|   --------------------------------------------------------   |
|                                                              |
|   Author: MiMiMi Community                                   |
|       > www.mimimi.software                                  |
|   Licensed under CC BY 4                                     |
|       > www.creativecommons.org/licenses/by/4.0              |
|                                                              |
|   --------------------------------------------------------   |
|                                                              |
|   Input variables:                                           |
|       $folder   = application's folder name (ended with /)   |
|       $filename = this template filepath (relative to the    |
|                   application's folder)                      |
|       $file     = this template's absolute filepath          |
|       $cms      = application's object                       |
|                                                              |
============================================================= */

    /* -----------------------------------------
    |                                          |
    |   Do some backend logic                  |
    |       > load the HELPER file             |
    |       > start the visitor's session      |
    |                                          |
    |   ------------------------------------   |
    |                                          |
    |   Note: See the HELPER.PHP file to       |
    |         understand this logic.           |
    |                                          |
    ----------------------------------------- */

    mimimiModule('helper.php');
    startSession();

    /* -----------------------------------------
    |                                          |
    |   Do some security logic                 |
    |       > if page STEP-4 is not passed     |
    |           > redirect to homepage         |
    |       > end if                           |
    |       > remember that STEP-5 isn't passed|
    |       > send status "200 OK"             |
    |                                          |
    ----------------------------------------- */

    if (hasNoCheckpoint('step4')) {
        gotoHome();
    }
    clearCheckpoint('step5');
    sendStatus200();

    /* -----------------------------------------
    |                                          |
    |   Simulate reading a post from database  |
    |                                          |
    ----------------------------------------- */

    global  $post;
            $post = array(
                'title'    => 'Install the MiMiMi - Contacts',
                'meta'     => 'This is an installer page to specify the contacts of your masters.',
                'keywords' => 'contacts page, specify contacts',
                'h1'       => 'Specify contacts'
            );

    /* =========================================================
    |                                                          |
    |   Make a content for the user                            |
    |                                                          |
    ========================================================= */

    /* -----------------------------------------
    |                                          |
    |   Display the page's top                 |
    |                                          |
    ----------------------------------------- */

    mimimiModule('blocks/header.php');

?>  <!-- ---------------------------------------
    |                                          |
    |   Display the page's content             |
    |                                          |
    ---------------------------------------- -->

    <main>
        <h1>
            <strong>Step 5 of 5</strong>
            <?php printPageH1() ?>
        </h1>

        <p>
            You need to specify the contacts of your masters.
            They are used to send system notifications to
            the relevant specialist when certain events
            occur on the website.
        </p>

        <!-- -----------------------------------
        |                                      |
        |   Display the form named FORM-5      |
        |                                      |
        ------------------------------------ -->

        <?php mimimiModule('blocks/form-5.php'); ?>
    </main>

<?php /* ---------------------------------------
    |                                          |
    |   Display the page's bottom              |
    |                                          |
    ----------------------------------------- */

    mimimiModule('blocks/footer.php');