<?php /* =======================================================
|                                                              |
|   Template to display the MiMiMi Installer's STEP-3 page     |
|                                                              |
|   --------------------------------------------------------   |
|                                                              |
|   Author: MiMiMi Community                                   |
|       > www.mimimi.software                                  |
|   Licensed under CC BY 4                                     |
|       > www.creativecommons.org/licenses/by/4.0              |
|                                                              |
|   --------------------------------------------------------   |
|                                                              |
|   Input variables:                                           |
|       $folder   = application's folder name (ended with /)   |
|       $filename = this template filepath (relative to the    |
|                   application's folder)                      |
|       $file     = this template's absolute filepath          |
|       $cms      = application's object                       |
|                                                              |
============================================================= */

    /* -----------------------------------------
    |                                          |
    |   Do some backend logic                  |
    |       > load the HELPER file             |
    |       > start the visitor's session      |
    |                                          |
    |   ------------------------------------   |
    |                                          |
    |   Note: See the HELPER.PHP file to       |
    |         understand this logic.           |
    |                                          |
    ----------------------------------------- */

    mimimiModule('helper.php');
    startSession();

    /* -----------------------------------------
    |                                          |
    |   Do some security logic                 |
    |       > if page STEP-2 is not passed     |
    |           > redirect to homepage         |
    |       > end if                           |
    |       > remember that STEP-3 isn't passed|
    |       > ... page STEP-4 is not passed    |
    |       > ... page STEP-5 is not passed    |
    |       > send status "200 OK"             |
    |                                          |
    ----------------------------------------- */

    if (hasNoCheckpoint('step2')) {
        gotoHome();
    }
    clearCheckpoint('step3');
    clearCheckpoint('step4');
    clearCheckpoint('step5');
    sendStatus200();

    /* -----------------------------------------
    |                                          |
    |   Simulate reading a post from database  |
    |                                          |
    ----------------------------------------- */

    global  $post;
            $post = array(
                'title'    => 'Install the MiMiMi - Modules',
                'meta'     => 'This is an installer page to choose which modules to be installed.',
                'keywords' => 'modules page, choose modules',
                'h1'       => 'Choose the modules'
            );

    /* =========================================================
    |                                                          |
    |   Make a content for the user                            |
    |                                                          |
    ========================================================= */

    /* -----------------------------------------
    |                                          |
    |   Display the page's top                 |
    |                                          |
    ----------------------------------------- */

    mimimiModule('blocks/header.php');

?>  <!-- ---------------------------------------
    |                                          |
    |   Display the page's content             |
    |                                          |
    ---------------------------------------- -->

    <main>
        <h1>
            <strong>Step 3 of 5</strong>
            <?php printPageH1() ?>
        </h1>

        <p>
            You need to choose which modules to be installed.
        </p>

        <!-- -----------------------------------
        |                                      |
        |   Display the form named FORM-3      |
        |                                      |
        ------------------------------------ -->

        <?php mimimiModule('blocks/form-3.php'); ?>
    </main>

<?php /* ---------------------------------------
    |                                          |
    |   Display the page's bottom              |
    |                                          |
    ----------------------------------------- */

    mimimiModule('blocks/footer.php');