<?php
/**
 * -------------------------------------------------------------------------
 *
 * The template for rendering the Error 404 page.
 *
 * -------------------------------------------------------------------------
 *
 * These global variables are available:
 *
 *     $item   = FALSE ( see file tiny.news.feed/Router/Router.php -> run -> $item )
 *     $items  = FALSE ( see file tiny.news.feed/Router/Router.php -> run -> $items )
 *     $page   = 0     ( see file tiny.news.feed/Router/Router.php -> run -> $page )
 *     $viewer = ?     ( see file tiny.news.feed/Router/Router.php -> run -> $viewer )
 *     $url    = ?     ( see file tiny.news.feed/Router/Router.php -> run -> $url )
 *
 * And these system variables:
 *
 *     $cms      = your application                                            ( see file mimimi.core/Routines.php -> mimimiInclude -> $cms )
 *     $params   = some parameters if they were passed by the calling template ( see file mimimi.core/Routines.php -> mimimiInclude -> $params )
 *     $folder   = relative path of the application's folder                   ( see file mimimi.core/Routines.php -> mimimiInclude -> $folder )
 *     $filename = relative path of this TPL file                              ( see file mimimi.core/Routines.php -> mimimiInclude -> $filename )
 *     $file     = absolute path of this TPL file                              ( see file mimimi.core/Routines.php -> mimimiInclude -> $file )
 *
 * -------------------------------------------------------------------------
 *
 * @package    MimimiFramework
 * @subpackage Examples / Tiny News Feed site
 * @license    GPL-2.0
 *             https://opensource.org/license/gpl-2-0/
 * @copyright  2022 MiMiMi Community
 *             https://mimimi.software/
 *
 * -------------------------------------------------------------------------
 */

/**
 * -------------------------------------------------------------------------
 *
 * Headers to be sent to the user's browser.
 *
 * -------------------------------------------------------------------------
 */

                                                        // -----------------
    sendHeaderHTML();                                   // it is HTML document                  ( see file mimimi.modules/Helper/Helper.php -> sendHeaderHTML )
    sendStatus404();                                    // availability status is 404 Not Found ( see file mimimi.modules/Helper/Helper.php -> sendStatus404 )
    sendHeaderExpires(0);                               // cache will expire immediately        ( see file mimimi.modules/Helper/Helper.php -> sendHeaderExpires )
    sendHeaderLastModified();                           // last modified time equals now        ( see file mimimi.modules/Helper/Helper.php -> sendHeaderLastModified )
                                                        // -----------------
    stopIfHead();                                       // stop execution if the request method is HEAD ( see file mimimi.modules/Helper/Helper.php -> stopIfHead )
                                                        // -----------------

/**
 * -------------------------------------------------------------------------
 *
 * HTML content to be sent to the user's browser.
 *
 * -------------------------------------------------------------------------
 */

                                                        // -----------------
    $row = [ 'h1'      => TINYFEED_ERROR404_H1,         // make a pseudo publication ( see file tiny.news.feed/Constants.php -> TINYFEED_ERROR404_H1 )
             'title'   => TINYFEED_ERROR404_TITLE,      // . . with this title       ( see file tiny.news.feed/Constants.php -> TINYFEED_ERROR404_TITLE )
             'meta'    => TINYFEED_ERROR404_META,       // . . with this short text  ( see file tiny.news.feed/Constants.php -> TINYFEED_ERROR404_META )
             'body'    => TINYFEED_ERROR404_BODY,       // . . with this full text   ( see file tiny.news.feed/Constants.php -> TINYFEED_ERROR404_BODY )
             'image'   => '',                           // . . no image
             'prefix'  => '',                           // . . no viewer segment
             'url'     => '',                           // . . canonical URL is home
             'enabled' => FALSE ];                      // . . for "noindex, nofollow" in the <meta> tag
                                                        // -----------------
?>
<!DOCTYPE html>
<html class="error" lang="<?php printValue(TINYFEED_HTMLPAGE_LANGUAGE) ?>" dir="ltr">
    <?php                                               // -----------------
        mimimiModule([                                  // render a snippet       ( see file mimimi.core/Routines.php -> mimimiModule )
            'snippets/head.tpl',                        // . . from this template ( see file tiny.news.feed/Themes/default/snippets/head.tpl )
            $row                                        // . . for this pseudo publication
        ]);                                             //
    ?>

    <!-- ---------------------------------------
    *                                          *
    * The website header.                      *
    *                                          *
    ---------------------------------------- -->

    <body>
        <?php                                           // -----------------
            mimimiModule([                              // render a snippet       ( see file mimimi.core/Routines.php -> mimimiModule )
                'snippets/header.tpl',                  // . . from this template ( see file tiny.news.feed/Themes/default/snippets/header.tpl )
                TINYFEED_INTERFACE_BREADCRUMBS_ERROR    // . . with this last breadcrumb node ( see file tiny.news.feed/Constants.php -> TINYFEED_INTERFACE_BREADCRUMBS_ERROR )
            ]);                                         //
                                                        // -----------------
            mimimiModule(                               // render a snippet       ( see file mimimi.core/Routines.php -> mimimiModule )
                'snippets/form-search.tpl'              // . . from this template ( see file tiny.news.feed/Themes/default/snippets/form-search.tpl )
            );                                          //
        ?>

        <!-- -----------------------------------
        *                                      *
        * The list of recent page cards.       *
        *                                      *
        ------------------------------------ -->

        <div class="content page">
            <?php                                       // -----------------
                mimimiModule([                          // render a snippet       ( see file mimimi.core/Routines.php -> mimimiModule )
                    'snippets/body.tpl',                // . . from this template ( see file tiny.news.feed/Themes/default/snippets/body.tpl )
                    $row                                // . . for this pseudo publication
                ]);                                     //
                                                        // -----------------
                $list = $cms->getLatest(2);             // get a list of latest publications ( see file tiny.news.feed/Application.php -> getLatest )
                mimimiModule([                          // render a snippet                  ( see file mimimi.core/Routines.php -> mimimiModule )
                    'snippets/results.tpl',             // . . from this template            ( see file tiny.news.feed/Themes/default/snippets/results.tpl )
                    $list                               // . . with this list
                ]);                                     //
            ?>
        </div>

        <!-- -----------------------------------
        *                                      *
        * Administrative tools.                *
        *                                      *
        ------------------------------------ -->

        <?php                                           // -----------------
            mimimiModule([                              // render a snippet       ( see file mimimi.core/Routines.php -> mimimiModule )
                'snippets/tools.tpl',                   // . . from this template ( see file tiny.news.feed/Themes/default/snippets/tools.tpl )
                FALSE                                   // . . as universal tools
            ]);                                         //
        ?>

        <!-- -----------------------------------
        *                                      *
        * The website footer.                  *
        *                                      *
        ------------------------------------ -->

        <?php                                           // -----------------
            mimimiModule(                               // render a snippet       ( see file mimimi.core/Routines.php -> mimimiModule )
                'snippets/footer.tpl'                   // . . from this template ( see file tiny.news.feed/Themes/default/snippets/footer.tpl )
            );                                          //
        ?>
    </body>
</html>