<?php
/**
 * -------------------------------------------------------------------------
 *
 * The template for rendering the home page.
 *
 * -------------------------------------------------------------------------
 *
 * How did this file run?
 *
 *     ├─> .htaccess
 *     └─> index.php
 *           ├─> tiny.news.feed/Config.php
 *           ├─> mimimi.core/Routines.php
 *           │               └─<─ routine mimimiModule()
 *           ├─> [MAKE THE $cms GLOBAL VARIABLE]
 *           ├─> tiny.news.feed/Constants.php
 *           │                  ├─<─ constant TINYFEED_HOMEPAGE_H1
 *           │                  ├─<─ constant TINYFEED_HOMEPAGE_TITLE
 *           │                  ├─<─ constant TINYFEED_HOMEPAGE_META
 *           │                  ├─<─ constant TINYFEED_HOMEPAGE_BODY
 *           │                  └─<─ constant TINYFEED_HTMLPAGE_LANGUAGE
 *           │                                         ┌─<─ class mimimi.core/Module.php
 *           │                  ┌─<─ class mimimi.core/UmbrellaModule.php
 *           └─> tiny.news.feed/Application.php
 *                              │    └─> run()                ┌─<─ class mimimi.core/Module.php
 *                              │         ├─> mimimi.core/Has/Has.php
 *                              │         │                         ┌─<─ class mimimi.core/Module.php
 *                              │         └─> tiny.news.feed/Router/Router.php
 *                              │                                      └─> run()
 *                              ├─<─ method amIAdmin()                      ├─> [MAKE THE $item GLOBAL VARIABLE  ]
 *                              └─<─ method getLatest()                     ├─> [MAKE THE $items GLOBAL VARIABLE ]
 *                                                                          ├─> [MAKE THE $page GLOBAL VARIABLE  ]
 *                                                                          ├─> [MAKE THE $viewer GLOBAL VARIABLE]
 *                                                                          ├─> [MAKE THE $url GLOBAL VARIABLE   ]
 *                                                                          └─> findMe()                     ┌─<─ class mimimi.core/Module.php
 *                                                                                 └─> tiny.news.feed/Themes/Themes.php
 *                                                                                                              ├─> checkFor()                                                    ┌─<─ class mimimi.core/Module.php
 *                                                                                                              └─> render()                     ┌─<─ class mimimi.modules/Helper/Helper.php
 *                                                                                                                     ├─> tiny.news.feed/Helper/Helper.php                       ├─<─ routine sendHeaderHTML()
 *                                                                                                                     │                                                          ├─<─ routine sendStatus200()
 *                                                                                                                     │                                                          ├─<─ routine sendHeaderExpires()
 *                                                                                                                     │                                                          ├─<─ routine sendHeaderLastModified()
 *                                                                                                                     │                                                          ├─<─ routine stopIfHead()
 *                                                                                                                     │                                                          ├─<─ routine printValue()
 *                                                                                                                     │                                                          └─<─ routine printThemeUrl()
 *                                                                                                                     └─> tiny.news.feed/Themes/default/home.tpl
 *                                                                                                                                                       │ └─> [SEND CONTENT TO THE BROWSER]
 *                                                                                                                                                       ├─<─ snippet tiny.news.feed/Themes/default/snippets/head.tpl
 *                                                                                                                                                       ├─<─ snippet tiny.news.feed/Themes/default/snippets/header.tpl
 *                                                                                                                                                       ├─<─ snippet tiny.news.feed/Themes/default/snippets/body.tpl
 *                                                                                                                                                       ├─<─ snippet tiny.news.feed/Themes/default/snippets/results.tpl
 *                                                                                                                                                       └─<─ snippet tiny.news.feed/Themes/default/snippets/tools.tpl
 *
 * The down-right arrows show the order in which app files are loaded and
 * their methods that are called when processing a request to the site.
 * The left-down arrows show the classes from which the corresponding
 * application file is derived. The left-up arrows show some of the public
 * routines or some of the public methods that the corresponding file
 * exposes to other application modules.
 *
 * -------------------------------------------------------------------------
 *
 * These global variables are available:
 *
 *     $item   = FALSE ( see file tiny.news.feed/Router/Router.php -> run -> $item )
 *     $items  = FALSE ( see file tiny.news.feed/Router/Router.php -> run -> $items )
 *     $page   = 0     ( see file tiny.news.feed/Router/Router.php -> run -> $page )
 *     $viewer = ''    ( see file tiny.news.feed/Router/Router.php -> run -> $viewer )
 *     $url    = ''    ( see file tiny.news.feed/Router/Router.php -> run -> $url )
 *
 * And these system variables:
 *
 *     $cms      = your application                                            ( see file mimimi.core/Routines.php -> mimimiInclude -> $cms )
 *     $params   = some parameters if they were passed by the calling template ( see file mimimi.core/Routines.php -> mimimiInclude -> $params )
 *     $folder   = relative path of the application's folder                   ( see file mimimi.core/Routines.php -> mimimiInclude -> $folder )
 *     $filename = relative path of this TPL file                              ( see file mimimi.core/Routines.php -> mimimiInclude -> $filename )
 *     $file     = absolute path of this TPL file                              ( see file mimimi.core/Routines.php -> mimimiInclude -> $file )
 *
 * -------------------------------------------------------------------------
 *
 * @package    MimimiFramework
 * @subpackage Examples / Tiny News Feed site
 * @license    GPL-2.0
 *             https://opensource.org/license/gpl-2-0/
 * @copyright  2022 MiMiMi Community
 *             https://mimimi.software/
 *
 * -------------------------------------------------------------------------
 */

                                                        // -----------------
    $okEdit = $cms->amIAdmin();                         // am I admin? ( see file tiny.news.feed/Application.php -> amIAdmin )
                                                        // -----------------

/**
 * -------------------------------------------------------------------------
 *
 * Headers to be sent to the user's browser.
 *
 * -------------------------------------------------------------------------
 */

                                                        // -----------------
    sendHeaderHTML();                                   // it is HTML document           ( see file mimimi.modules/Helper/Helper.php -> sendHeaderHTML )
    sendStatus200();                                    // availability status is 200 OK ( see file mimimi.modules/Helper/Helper.php -> sendStatus200 )
    sendHeaderExpires(                                  // cache will expire             ( see file mimimi.modules/Helper/Helper.php -> sendHeaderExpires )
        $okEdit ? 0                                     // . . immediately if user is an admin
                : 1                                     // . . otherwise after 1 hour
    );                                                  //
    sendHeaderLastModified();                           // last modified time equals now ( see file mimimi.modules/Helper/Helper.php -> sendHeaderLastModified )
                                                        // -----------------
    stopIfHead();                                       // stop execution if the request method is HEAD ( see file mimimi.modules/Helper/Helper.php -> stopIfHead )
                                                        // -----------------

/**
 * -------------------------------------------------------------------------
 *
 * HTML content to be sent to the user's browser.
 *
 * -------------------------------------------------------------------------
 */

                                                        // -----------------
    $row = [ 'h1'      => TINYFEED_HOMEPAGE_H1,         // make a pseudo publication ( see file tiny.news.feed/Constants.php -> TINYFEED_HOMEPAGE_H1 )
             'title'   => TINYFEED_HOMEPAGE_TITLE,      // . . with this title       ( see file tiny.news.feed/Constants.php -> TINYFEED_HOMEPAGE_TITLE )
             'meta'    => TINYFEED_HOMEPAGE_META,       // . . with this short text  ( see file tiny.news.feed/Constants.php -> TINYFEED_HOMEPAGE_META )
             'body'    => TINYFEED_HOMEPAGE_BODY,       // . . with this full text   ( see file tiny.news.feed/Constants.php -> TINYFEED_HOMEPAGE_BODY )
             'image'   => '',                           // . . no image
             'prefix'  => '',                           // . . no viewer segment
             'url'     => '',                           // . . canonical URL is home
             'enabled' => TRUE ];                       // . . for "index, follow" in the <meta> tag
                                                        // -----------------
?>
<!DOCTYPE html>
<html class="home" lang="<?php printValue(TINYFEED_HTMLPAGE_LANGUAGE) ?>" dir="ltr">
    <?php                                               // -----------------
        mimimiModule([                                  // render a snippet       ( see file mimimi.core/Routines.php -> mimimiModule )
            'snippets/head.tpl',                        // . . from this template ( see file tiny.news.feed/Themes/default/snippets/head.tpl )
            $row                                        // . . for this pseudo publication
        ]);                                             //
    ?>

    <!-- ---------------------------------------
    *                                          *
    * The website header.                      *
    *                                          *
    ---------------------------------------- -->

    <body>
        <?php                                           // -----------------
            mimimiModule([                              // render a snippet       ( see file mimimi.core/Routines.php -> mimimiModule )
                'snippets/header.tpl',                  // . . from this template ( see file tiny.news.feed/Themes/default/snippets/header.tpl )
                TINYFEED_INTERFACE_BREADCRUMBS_HOME     // . . with this last breadcrumb node ( see file tiny.news.feed/Constants.php -> TINYFEED_INTERFACE_BREADCRUMBS_HOME )
            ]);                                         //
                                                        // -----------------
            mimimiModule(                               // render a snippet       ( see file mimimi.core/Routines.php -> mimimiModule )
                'snippets/form-search.tpl'              // . . from this template ( see file tiny.news.feed/Themes/default/snippets/form-search.tpl )
            );                                          //
        ?>

        <!-- -----------------------------------
        *                                      *
        * The list of recent page cards.       *
        *                                      *
        ------------------------------------ -->

        <main class="content list">
            <?php                                       // -----------------
                mimimiModule([                          // render a snippet       ( see file mimimi.core/Routines.php -> mimimiModule )
                    'snippets/body.tpl',                // . . from this template ( see file tiny.news.feed/Themes/default/snippets/body.tpl )
                    $row                                // . . for this pseudo publication
                ]);                                     //
                                                        // -----------------
                $list = $cms->getLatest(4);             // get a list of latest publications ( see file tiny.news.feed/Application.php -> getLatest )
                mimimiModule([                          // render a snippet                  ( see file mimimi.core/Routines.php -> mimimiModule )
                    'snippets/results.tpl',             // . . from this template            ( see file tiny.news.feed/Themes/default/snippets/results.tpl )
                    $list                               // . . with this list
                ]);                                     //
            ?>
        </main>

        <!-- -----------------------------------
        *                                      *
        * Administrative tools.                *
        *                                      *
        ------------------------------------ -->

        <?php                                           // -----------------
            mimimiModule([                              // render a snippet       ( see file mimimi.core/Routines.php -> mimimiModule )
                'snippets/tools.tpl',                   // . . from this template ( see file tiny.news.feed/Themes/default/snippets/tools.tpl )
                FALSE                                   // . . as universal tools
            ]);                                         //
        ?>

        <!-- -----------------------------------
        *                                      *
        * The website footer.                  *
        *                                      *
        ------------------------------------ -->

        <?php                                           // -----------------
            mimimiModule(                               // render a snippet       ( see file mimimi.core/Routines.php -> mimimiModule )
                'snippets/footer.tpl'                   // . . from this template ( see file tiny.news.feed/Themes/default/snippets/footer.tpl )
            );                                          //
        ?>
    </body>
</html>