<?php
/**
 * -------------------------------------------------------------------------
 *
 * The template for rendering the News Add page.
 *
 * -------------------------------------------------------------------------
 *
 * These global variables are available:
 *
 *     $item   = the current news record ( see file tiny.news.feed/Router/Router.php -> run -> $item )
 *     $items  = FALSE                   ( see file tiny.news.feed/Router/Router.php -> run -> $items )
 *     $page   = 0                       ( see file tiny.news.feed/Router/Router.php -> run -> $page )
 *     $viewer = 'news'                  ( see file tiny.news.feed/Router/Router.php -> run -> $viewer )
 *     $url    = ?                       ( see file tiny.news.feed/Router/Router.php -> run -> $url )
 *
 * And these system variables:
 *
 *     $cms      = your application                                            ( see file mimimi.core/Routines.php -> mimimiInclude -> $cms )
 *     $params   = some parameters if they were passed by the calling template ( see file mimimi.core/Routines.php -> mimimiInclude -> $params )
 *     $folder   = relative path of the application's folder                   ( see file mimimi.core/Routines.php -> mimimiInclude -> $folder )
 *     $filename = relative path of this TPL file                              ( see file mimimi.core/Routines.php -> mimimiInclude -> $filename )
 *     $file     = absolute path of this TPL file                              ( see file mimimi.core/Routines.php -> mimimiInclude -> $file )
 *
 * -------------------------------------------------------------------------
 *
 * @package    MimimiFramework
 * @subpackage Examples / Tiny News Feed site
 * @license    GPL-2.0
 *             https://opensource.org/license/gpl-2-0/
 * @copyright  2022 MiMiMi Community
 *             https://mimimi.software/
 *
 * -------------------------------------------------------------------------
 */

/**
 * -------------------------------------------------------------------------
 *
 * Headers to be sent to the user's browser.
 *
 * -------------------------------------------------------------------------
 */

                                                        // -----------------
    sendHeaderHTML();                                   // it is HTML document           ( see file mimimi.modules/Helper/Helper.php -> sendHeaderHTML )
    sendStatus200();                                    // availability status is 200 OK ( see file mimimi.modules/Helper/Helper.php -> sendStatus200 )
    sendHeaderExpires(0);                               // cache will expire immediately ( see file mimimi.modules/Helper/Helper.php -> sendHeaderExpires )
    sendHeaderLastModified();                           // last modified time equals now ( see file mimimi.modules/Helper/Helper.php -> sendHeaderLastModified )
                                                        // -----------------
    stopIfHead();                                       // stop execution if the request method is HEAD ( see file mimimi.modules/Helper/Helper.php -> stopIfHead )
                                                        // -----------------

/**
 * -------------------------------------------------------------------------
 *
 * Take the steps that match the functionality of this page.
 *
 * -------------------------------------------------------------------------
 */

                                                        // -----------------
    global $item;                                       // refer to the incoming variable
                                                        // -----------------
    ob_start();                                         // start buffering a form content
        mimimiModule([                                  //     render a snippet       ( see file mimimi.core/Routines.php -> mimimiModule )
            'snippets/form-news.tpl',                   //     . . from this template ( see file tiny.news.feed/Themes/default/snippets/form-news.tpl )
            $item                                       //     . . for this publication
        ]);                                             //
                                                        // -----------------
        $form = ob_get_contents();                      //     store that form content to display below
    ob_end_clean();                                     // stop buffering
                                                        // -----------------

/**
 * -------------------------------------------------------------------------
 *
 * HTML content to be sent to the user's browser.
 *
 * -------------------------------------------------------------------------
 */

                                                        // -----------------
    $row = [ 'h1'      => TINYFEED_NEWSEDIT_H1,         // make a pseudo publication ( see file tiny.news.feed/Constants.php -> TINYFEED_NEWSEDIT_H1 )
             'title'   => TINYFEED_NEWSEDIT_TITLE,      // . . with this title       ( see file tiny.news.feed/Constants.php -> TINYFEED_NEWSEDIT_TITLE )
             'meta'    => TINYFEED_NEWSEDIT_META,       // . . with this short text  ( see file tiny.news.feed/Constants.php -> TINYFEED_NEWSEDIT_META )
             'body'    => '',                           // . . no full text
             'image'   => '',                           // . . no image
             'prefix'  => '',                           // . . no viewer segment
             'url'     => '',                           // . . canonical URL is home
             'enabled' => FALSE ];                      // . . for "noindex, nofollow" in the <meta> tag
                                                        // -----------------
?>
<!DOCTYPE html>
<html class="news edit" lang="<?php printValue(TINYFEED_HTMLPAGE_LANGUAGE) ?>" dir="ltr">
    <?php                                               // -----------------
        mimimiModule([                                  // render a snippet       ( see file mimimi.core/Routines.php -> mimimiModule )
            'snippets/head.tpl',                        // . . from this template ( see file tiny.news.feed/Themes/default/snippets/head.tpl )
            $row                                        // . . for this pseudo publication
        ]);                                             //
    ?>

    <!-- ---------------------------------------
    *                                          *
    * The website header.                      *
    *                                          *
    ---------------------------------------- -->

    <body>
        <?php                                           // -----------------
            mimimiModule([                              // render a snippet       ( see file mimimi.core/Routines.php -> mimimiModule )
                'snippets/header.tpl',                  // . . from this template ( see file tiny.news.feed/Themes/default/snippets/header.tpl )
                TINYFEED_INTERFACE_BREADCRUMBS_EDIT     // . . with this last breadcrumb node ( see file tiny.news.feed/Constants.php -> TINYFEED_INTERFACE_BREADCRUMBS_EDIT )
            ]);                                         //
        ?>

        <!-- -----------------------------------
        *                                      *
        * Administrative form.                 *
        *                                      *
        ------------------------------------ -->

        <form class="paginator form" method="post" enctype="multipart/form-data">
            <?php                                       // -----------------
                mimimiModule([                          // render a snippet       ( see file mimimi.core/Routines.php -> mimimiModule )
                    'snippets/body.tpl',                // . . from this template ( see file tiny.news.feed/Themes/default/snippets/body.tpl )
                    $row                                // . . for this pseudo publication
                ]);                                     //
                                                        // -----------------
                echo $form;                             // display the form content generated above
            ?>
        </form>

        <!-- -----------------------------------
        *                                      *
        * The website footer.                  *
        *                                      *
        ------------------------------------ -->

        <?php                                           // -----------------
            mimimiModule(                               // render a snippet       ( see file mimimi.core/Routines.php -> mimimiModule )
                'snippets/footer.tpl'                   // . . from this template ( see file tiny.news.feed/Themes/default/snippets/footer.tpl )
            );                                          //
        ?>
    </body>
</html>