<?php
/**
 * -------------------------------------------------------------------------
 *
 * The snippet for rendering the pagination and administrative tools.
 *
 * -------------------------------------------------------------------------
 *
 * These global variables are available:
 *
 *     $items  = array of publications listed on the current list page ( see file tiny.news.feed/Router/Router.php -> run -> $items )
 *     $page   = number of the current list page                       ( see file tiny.news.feed/Router/Router.php -> run -> $page )
 *
 * And these system variables:
 *
 *     $params   = name of the current viewer                ( see file tiny.news.feed/Themes/default/*-list.tpl )
 *     $cms      = your application                          ( see file mimimi.core/Routines.php -> mimimiInclude -> $cms )
 *     $folder   = relative path of the application's folder ( see file mimimi.core/Routines.php -> mimimiInclude -> $folder )
 *     $filename = relative path of this TPL file            ( see file mimimi.core/Routines.php -> mimimiInclude -> $filename )
 *     $file     = absolute path of this TPL file            ( see file mimimi.core/Routines.php -> mimimiInclude -> $file )
 *
 * -------------------------------------------------------------------------
 *
 * @package    MimimiFramework
 * @subpackage Examples / Tiny News Feed site
 * @license    GPL-2.0
 *             https://opensource.org/license/gpl-2-0/
 * @copyright  2022 MiMiMi Community
 *             https://mimimi.software/
 *
 * -------------------------------------------------------------------------
 */

                                                        // -----------------
    $okAdd = $cms->amIAdmin();                          // am I admin? ( see file tiny.news.feed/Application.php -> amIAdmin )
    if ( $okAdd ) {                                     // if it's true
                                                        // -----------------
        $list = $cms->getViewers(                       //     get a list of viewer names ( see file tiny.news.feed/Application.php -> getViewers )
                    '*-add.tpl'                         //     . . which have an editor template for adding
                );                                      //
        $okAdd = ! empty($list);                        //     check for the Add buttons
    }                                                   //
                                                        // -----------------
    global $page;                                       // refer to the incoming variable
    $okPrev = $page > 1;                                // check for the Prev button
                                                        // -----------------
    global $items;                                      // refer to the incoming variable
    $okNext = $items && end($items) == FALSE;           // check for the Next button
                                                        // -----------------
    if ( $okAdd || $okPrev || $okNext ) {               // if something is true
        $root = [ 'url' => $params ];                   //     make pseudo record for the root of the current viewer list
                                                        // -----------------
        $numPrev = $page > 2                            //     make valid SEO numbering
                       ? '/page-' . ($page - 1)         //     . . for other pages
                       : '';                            //     . . for first page
                                                        // -----------------
        $query = '';                                    //     no URL query part now
        if ( $params == 'search' ) {                    //     if we stay on Search page
            $query = $cms                               //         get the query string
                     ->viewers                          //         . . via VIEWERS module ( see file tiny.news.feed/Viewers/Viewers.php -> getQueryParam )
                     ->getQueryParam(                   //         . . using this method
                         'q'                            //             . . from this POST or GET parameter ( see the INPUT tag below named "q" )
                     );                                 //
            $query = '?q=' . urlencode($query);         //         build a URL query part
        }                                               //
        ?>
        <nav class="paginator">
            <?php                                       // -----------------
                if ( $okPrev ) {                        //     if this page contains the Prev button
                    ?>
                    <a class="btn back" href="<?php
                                                  tinyPrintUrl($root);
                                                  printValue($numPrev);
                                                  printValue($query);
                                              ?>">
                        <?php printValue(TINYFEED_INTERFACE_PREV) ?>
                    </a>
                    <?php                               //
                }                                       //
                                                        // -----------------
                if ( $okAdd ) {                         //     if I'm an admin and there are the Add buttons
                    mimimiModule([                      //         render a snippet       ( see file mimimi.core/Routines.php -> mimimiModule )
                        'snippets/buttons-add.tpl',     //         . . from this template ( see file tiny.news.feed/Themes/default/snippets/buttons-add.tpl )
                        $list                           //         . . for this viewer list
                    ]);                                 //
                }                                       //
                                                        // -----------------
                if ( $okNext ) {                        //     if this page contains the Next button
                    ?>
                    <a class="btn next" href="<?php tinyPrintUrl($root) ?>/page-<?php
                                                                                    printValue($page + 1);
                                                                                    printValue($query);
                                                                                ?>">
                        <?php printValue(TINYFEED_INTERFACE_NEXT) ?>
                    </a>
                    <?php                               //
                }                                       //
            ?>
        </nav>
        <?php                                           //
    }                                                   //
                                                        // -----------------
