<?php
/**
 * -------------------------------------------------------------------------
 * Class for the default application.
 *
 * See these elements to understand how the app works:
 *     .htaccess
 *     index.php
 *           ├─> mimimi.core/Config.php
 *           │                      └─> MIMIMI_CORE_THEME
 *           ├─> mimimi.core/Routines.php
 *           │                        ├─> mimimiCheck()
 *           │                        ├─> mimimiInclude()
 *           │                        └─> mimimiModule()
 *           └─> mimimi.core/Application.php
 *                           │           └─> run()
 *                           │                └─> mimimi.core/Themes/default/home.php
 *                           │                                               │    └─> helper.php
 *                           │                                               └─> [SEND HTML TO BROWSER]
 *                           └─<<<── mimimi.core/UmbrellaModule.php
 *                                               └─<<<── mimimi.core/Module.php
 *
 * -------------------------------------------------------------------------
 *
 * Overridden methods below are:
 *     run
 *
 * -------------------------------------------------------------------------
 *
 * @package    MimimiFramework
 * @subpackage Core
 * @copyright  2022 MiMiMi Community
 *             https://mimimi.software/
 * @license    CC BY 4
 *             https://www.creativecommons.org/licenses/by/4.0
 * -------------------------------------------------------------------------
 */

mimimiCheck();
mimimiInclude('UmbrellaModule.php');
class MimimiApplication extends MimimiUmbrellaModule {

    /**
     * ---------------------------------------------------------------------
     * Public method to run this module.
     *
     * It renders the page at the current URL, that is it generates HTML
     * content based on the homepage template.
     *
     * @public
     * @param   mixed  $params  Some parameters if you need.
     * @return  mixed           Some results if you need.
     * ---------------------------------------------------------------------
     */

    public function run ( $params = '' ) {
        mimimiModule('home.php', true);
    }
};