<?php
/**
 * -------------------------------------------------------------------------
 * The SECTIONS module to work with the subtable of SETTINGS database table.
 *
 * -------------------------------------------------------------------------
 *
 * Overridden properties below are:
 *     PROTECTED  $table  ───────────> PUBLIC
 *     PROTECTED  $tableFields
 *                      ├──> settings_section_id     INTEGER (auto incremented)
 *                      ├──> settings_section_alias  STRING  (length 50)
 *                      ├──> settings_section_name   STRING  (length 150)
 *                      ├──> settings_section_info   STRING  (length 500)
 *                      └──> settings_section_order  INTEGER
 *     PROTECTED  $tableKeys
 *                      ├──> settings_section_id     UNIQUE
 *                      ├──> settings_section_alias  UNIQUE
 *                      ├──> settings_section_name   UNIQUE
 *                      ├──> settings_section_order, settings_section_alias
 *                      └──> settings_section_order, settings_section_name
 *
 * Overridden methods below are:
 *     save
 *
 * -------------------------------------------------------------------------
 *
 * @package    MimimiFramework
 * @subpackage Modules
 * @copyright  2022 MiMiMi Community
 *             https://mimimi.software/
 * @license    CC BY 4
 *             https://www.creativecommons.org/licenses/by/4.0
 * -------------------------------------------------------------------------
 */

mimimiInclude('ModuleWithTable.php');
class MimimiSettingsSections extends MimimiModuleWithTable {

    /**
     * ---------------------------------------------------------------------
     * Database table name.
     *
     * Note: The maximum length for table names, column names, and indexes
     *       is 64 characters.
     *
     * @var string
     * @access public
     * ---------------------------------------------------------------------
     */

    public $table = 'settings_sections';

    /**
     * ---------------------------------------------------------------------
     * Database table columns.
     *
     * Note: The maximum length for table names, column names, and indexes
     *       is 64 characters.
     *
     * Note: Data type storage requirements:
     *       BIGINT    = 8 bytes;
     *       VARCHAR   = the actual length of a given string value + 1
     *                   byte if the multibyte value column requires 0 to
     *                   255 bytes to store the values, or the actual length
     *                   + 2 bytes if that column requires more than 255
     *                   bytes.
     *
     * @var array
     * @access protected
     * ---------------------------------------------------------------------
     */

    protected $tableFields = [
                  '`settings_section_id`     BIGINT(20)    NOT NULL  AUTO_INCREMENT  COMMENT "unique identifier of the settings section"',
                  '`settings_section_alias`  VARCHAR(50)   NOT NULL  DEFAULT ""      COMMENT "unique alias for filtering by this section"',
                  '`settings_section_name`   VARCHAR(150)  NOT NULL  DEFAULT ""      COMMENT "unique name for this section to display"',
                  '`settings_section_info`   VARCHAR(500)  NOT NULL  DEFAULT ""      COMMENT "optional description of this section if you need to explain it"',
                  '`settings_section_order`  INT(11)       NOT NULL                  COMMENT "position of this section when sorting"'
              ];

    /**
     * ---------------------------------------------------------------------
     * Database table keys.
     *
     * Note: The maximum length for table names, column names, and indexes
     *       is 64 characters.
     *
     * @var array
     * @access protected
     * ---------------------------------------------------------------------
     */

    protected $tableKeys = [
                  'PRIMARY KEY (`settings_section_id`)',
                  'KEY         (`settings_section_order`, `settings_section_alias`)',
                  'UNIQUE  KEY (                          `settings_section_alias`)',
                  'KEY         (`settings_section_order`, `settings_section_name`)',
                  'UNIQUE  KEY (                          `settings_section_name`)'
              ];

    /**
     * ---------------------------------------------------------------------
     * Saves entry of the settings section in the database.
     *
     * @public
     * @param   array     $item      The list of fields that need to be saved for the entry.
     * @param   string    $idColumn  (optional) The name of the column containing the entry identifier.
     * @return  int|bool             INTEGER if success, it is identifier of the saved entry.
     *                               FALSE   if failure.
     * ---------------------------------------------------------------------
     */

    public function save ( $item, $idColumn = 'settings_section_id' ) {
        return parent::save($item, $idColumn);
    }
};