<?php
/**
 * -------------------------------------------------------------------------
 *
 * Template for rendering the "Add Newspaper" page.
 *
 * -------------------------------------------------------------------------
 *
 * These global variables are available:
 *     $cms = your application
 *
 * -------------------------------------------------------------------------
 */
    
    /**
     * ---------------------------------------------------------------------
     *
     * Build an empty newspaper row.
     *
     * ---------------------------------------------------------------------
     */

    $params = myGenerateNewspaper();
    
    /**
     * ---------------------------------------------------------------------
     *
     * Process the submitted form.
     *
     * ---------------------------------------------------------------------
     */

    ob_start();
        mimimiModule([
            'snippets/form-newspaper.tpl',
            $params
        ]);
        $form = ob_get_contents();
    ob_end_clean();

    /**
     * ---------------------------------------------------------------------
     *
     * Send headers to the user's browser.
     *
     * ---------------------------------------------------------------------
     */

    sendHeaderHTML();
    sendStatus200();
    sendHeaderExpires( 0 );
    sendHeaderLastModified();

    /**
     * ---------------------------------------------------------------------
     *
     * Generate the page content.
     *
     * ---------------------------------------------------------------------
     */

?><!DOCTYPE html>
<html class="newspaper add" lang="<?php myPrintSetting( 'add_language' ) ?>">
    <head>
        <base href="<?php printSiteUrl() ?>">
        <meta charset="UTF-8">
        <meta name="viewport"    content="width=device-width, initial-scale=1">

        <title>
            <?php myPrintSetting( 'add_title' ) ?>
        </title>
        <meta name="description" content="<?php myPrintSetting( 'add_meta' ) ?>">
        <meta name="robots"      content="noindex, nofollow">
        <link rel="canonical"    href="<?php printSiteUrl() ?>">

        <link rel="stylesheet"   href="<?php printThemeUrl() ?>css/fonts.css">
        <link rel="stylesheet"   href="<?php printThemeUrl() ?>css/reset.css">
        <link rel="stylesheet"   href="<?php printThemeUrl() ?>css/styles.css">
    </head>

    <body>
        <div class="page">
            <input class="switch" type="checkbox" id="switch-test">
            <label class="btn test" for="switch-test" tabindex="1" onclick="clickTest(this)">
                <?php myPrintSetting( 'button_test' ) ?>
            </label>

            <!--
             * -------------------------------------------------------------
             *
             * An editing area.
             *
             * -------------------------------------------------------------
             -->

            <div class="wrapper">
                <div class="edition">
                    <?php myPrintSetting( 'add_edition' ) ?>
                </div>

                <aside class="header">
                    <div class="wrapper">
                        <div class="number">
                            <?php myPrintSetting( 'add_number' ) ?>
                        </div>
                        <div class="slogan">
                            <?php myPrintSetting( 'add_slogan' ) ?>
                        </div>
                    </div>
                </aside>

                <form class="content form newspaper" method="post" enctype="multipart/form-data">
                    <?php echo $form ?>
                </form>

                <aside class="footer">
                    <div class="wrapper">
                        <div class="copyright">
                            <?php myPrintSetting( 'home_copyright' ) ?>
                        </div>
                    </div>
                </aside>
            </div>

            <!--
             * -------------------------------------------------------------
             *
             * A testing area. It will be filled in later when you press
             * the "Test This" button.
             *
             * -------------------------------------------------------------
             -->

            <div class="wrapper test">
            </div>

            <?php
                /**
                 * ---------------------------------------------------------
                 *
                 * Generate some pointers to website pages.
                 *
                 * ---------------------------------------------------------
                 */

                mimimiModule([
                    'snippets/signpost.tpl',
                    $params
                ]);
            ?>
        </div>

        <script src="<?php printThemeUrl() ?>js/scripts.js"></script>
    </body>
</html>