<?php
/**
 * -------------------------------------------------------------------------
 *
 * Template for rendering the "Delete Newspaper" page.
 *
 * -------------------------------------------------------------------------
 *
 * These global variables are available:
 *     $cms    = your application
 *     $params = newspaper database row to delete
 *
 * -------------------------------------------------------------------------
 */

    /**
     * ---------------------------------------------------------------------
     *
     * Process the submitted form.
     *
     * ---------------------------------------------------------------------
     */

    $error   = '';
    $success = '';

    // check for form availability
    $ok = getFormInput( 'submit' );
    if ( $ok ) {

        // check for approval
        $ok = getFormInput( 'sure' );
        if ( $ok ) {

            // check for production (not demo) mode
            $ok = myGetSetting( 'on_production' );
            if ( $ok ) {

                // delete the newspaper
                $id = $params[ 'id' ];
                $cms->newspapers->remove( $id );

                // delete the articles attached to it
                myRemoveArticles( $params );

                // redirect to the home page (307 = temporary, not cached)
                $url = printSiteUrl(FALSE);
                mimimiStop( $url, 307 );

            } else {
                $success = myGetSetting( 'error_demo' );
            }

        } else {
            $error = myGetSetting( 'error_sure' );
        }
    }

    /**
     * ---------------------------------------------------------------------
     *
     * Send headers to the user's browser.
     *
     * ---------------------------------------------------------------------
     */

    sendHeaderHTML();
    sendStatus200();
    sendHeaderExpires( 0 );
    sendHeaderLastModified();

    /**
     * ---------------------------------------------------------------------
     *
     * Generate the page content.
     *
     * ---------------------------------------------------------------------
     */

?><!DOCTYPE html>
<html class="newspaper delete" lang="<?php myPrintSetting( 'delete_language' ) ?>">
    <head>
        <base href="<?php printSiteUrl() ?>">
        <meta charset="UTF-8">
        <meta name="viewport"    content="width=device-width, initial-scale=1">

        <title>
            <?php myPrintSetting( 'delete_title' ) ?>
        </title>
        <meta name="description" content="<?php myPrintSetting( 'delete_meta' ) ?>">
        <meta name="robots"      content="noindex, nofollow">
        <link rel="canonical"    href="<?php printSiteUrl() ?>">

        <link rel="stylesheet"   href="<?php printThemeUrl() ?>css/fonts.css">
        <link rel="stylesheet"   href="<?php printThemeUrl() ?>css/reset.css">
        <link rel="stylesheet"   href="<?php printThemeUrl() ?>css/styles.css">
    </head>

    <body>
        <div class="page">
            <div class="wrapper">
                <div class="edition">
                    <?php myPrintSetting( 'delete_edition' ) ?>
                </div>

                <aside class="header">
                    <div class="wrapper">
                        <div class="number">
                            <?php myPrintSetting( 'delete_number' ) ?>
                        </div>
                        <div class="slogan">
                            <?php myPrintSetting( 'delete_slogan' ) ?>
                        </div>
                    </div>
                </aside>

                <form class="content form newspaper" method="post">
                    <div class="error"  ><?php printValue( $error   ) ?></div>
                    <div class="success"><?php printValue( $success ) ?></div>

                    <?php
                        mimimiModule([
                            'snippets/list-newspapers.tpl',
                            myGetSetting( 'delete_meta' ),
                            [ $params ]
                        ]);
                    ?>

                    <hr>

                    <fieldset class="switcher">
                        <label>
                            <input name="sure" value="1" type="checkbox">
                            <?php myPrintSetting( 'delete_sure' ) ?>
                        </label>
                    </fieldset>

                    <button class="btn submit" name="submit" value="1" type="submit">
                        <?php myPrintSetting( 'delete_submit' ) ?>
                    </button>

                    <a class="btn cancel" href="<?php printSiteUrl() ?>">
                        <?php myPrintSetting( 'delete_cancel' ) ?>
                    </a>
                </form>

                <aside class="footer">
                    <div class="wrapper">
                        <div class="copyright">
                            <?php myPrintSetting( 'home_copyright' ) ?>
                        </div>
                        <a class="credits" href="https://mimimi.software/" rel="nofollow noopener noreferrer" tabindex="-1">
                            Powered by MiMiMi
                        </a>
                    </div>
                </aside>
            </div>

            <?php
                /**
                 * ---------------------------------------------------------
                 *
                 * Generate some pointers to website pages.
                 *
                 * ---------------------------------------------------------
                 */

                mimimiModule([
                    'snippets/signpost.tpl',
                    $params
                ]);
            ?>
        </div>

        <script src="<?php printThemeUrl() ?>js/scripts.js"></script>
    </body>
</html>