<?php
/**
 * -------------------------------------------------------------------------
 *
 * Snippet for rendering the editing and administrative tools.
 *
 * -------------------------------------------------------------------------
 *
 * These global variables are available:
 *     $cms    = your application
 *     $params = FALSE or the newspaper database row
 *
 * -------------------------------------------------------------------------
 */

    /**
     * ---------------------------------------------------------------------
     *
     * If an editor or admin is currently logged in.
     *
     * ---------------------------------------------------------------------
     */

    if ( $cms->isAdmin() ) {

        // display the editor main button
        ?>
        <aside class="tools">
            <a class="btn add" href="<?php printSiteUrl() ?>add" rel="nofollow">
                <?php myPrintSetting( 'button_add' ) ?>
            </a>

            <?php
                /**
                 * ---------------------------------------------------------
                 *
                 * If this user is currently on a newspaper page.
                 *
                 * ---------------------------------------------------------
                 */

                if ( $params ) {

                    // display other editor buttons
                    ?>
                    <a class="btn edit"   href="<?php printValue( $params[ 'url' ] ) ?>/edit"   rel="nofollow">
                        <?php myPrintSetting( 'button_edit' ) ?>
                    </a>

                    <a class="btn delete" href="<?php printValue( $params[ 'url' ] ) ?>/delete" rel="nofollow">
                        <?php myPrintSetting( 'button_delete' ) ?>
                    </a>
                    <?php
                }

                /**
                 * ---------------------------------------------------------
                 *
                 * If an admin is currently logged in.
                 *
                 * ---------------------------------------------------------
                 */

                if ( $cms->isAdmin( FALSE ) ) {

                    // display administrative buttons
                    ?>
                    <a class="btn settings" href="<?php printSiteUrl() ?>settings"   rel="nofollow">
                        <?php myPrintSetting( 'button_settings' ) ?>
                    </a>

                    <a class="btn robots"   href="<?php printSiteUrl() ?>robots.txt" rel="nofollow" target="_blank">
                        robots.txt
                    </a>

                    <a class="btn sitemap"  href="<?php printSiteUrl() ?>sitemap"    rel="nofollow" target="_blank">
                        sitemap.xml
                    </a>
                    <?php
                }
            ?>
        </aside>
        <?php
    }
