<?php
/**
 * -------------------------------------------------------------------------
 *
 * The snippet for rendering the publication list.
 *
 * -------------------------------------------------------------------------
 *
 * These global variables are available:
 *
 *     $items  = array of publications ( see file tiny.news.feed/Themes/default/*-list.tpl -> $items )
 *
 * And these system variables:
 *
 *     $params   = name of the desired viewer                ( see file tiny.news.feed/Themes/default/*-list.tpl )
 *     $cms      = your application                          ( see file mimimi.core/Routines.php -> mimimiInclude -> $cms )
 *     $folder   = relative path of the application's folder ( see file mimimi.core/Routines.php -> mimimiInclude -> $folder )
 *     $filename = relative path of this TPL file            ( see file mimimi.core/Routines.php -> mimimiInclude -> $filename )
 *     $file     = absolute path of this TPL file            ( see file mimimi.core/Routines.php -> mimimiInclude -> $file )
 *
 * -------------------------------------------------------------------------
 *
 * @package    MimimiFramework
 * @subpackage Examples / Tiny News Feed site
 * @license    GPL-2.0
 *             https://opensource.org/license/gpl-2-0/
 * @copyright  2022 MiMiMi Community
 *             https://mimimi.software/
 *
 * -------------------------------------------------------------------------
 */

                                                        // -----------------
    global $items;                                      // refer to the incoming variable
    if ( $items ) {                                     // if there is a non-empty list
                                                        // -----------------
        $file = "snippets/card-$params.tpl";            //     build specific template filename ( see file tiny.news.feed/Themes/default/snippets/card-[$params].tpl )
        $ok = $cms                                      //     find it
              ->themes                                  //     . . via THEMES module            ( see file tiny.news.feed/Themes/Themes.php -> checkFor )
              ->checkFor($file);                        //     . . using this method
                                                        // -----------------
        if ( ! $ok ) {                                  //     if it is not found
            $file = 'snippets/card.tpl';                //         build default template filename ( see file tiny.news.feed/Themes/default/snippets/card.tpl )
            $ok = $cms                                  //         find it
                  ->themes                              //         . . via THEMES module           ( see file tiny.news.feed/Themes/Themes.php -> checkFor )
                  ->checkFor($file);                    //         . . using this method
        }                                               //
                                                        // -----------------
        if ( $ok ) {                                    //     if template is found
            ?>
            <section class="listing <?php printValue($params) ?>">
                <?php                                   // -----------------
                    foreach ( $items as $row ) {        //         walk through the provided list
                        if ( $row ) {                   //             if it is not the Next Page marker
                            mimimiModule([              //                 render a snippet ( see file mimimi.core/Routines.php -> mimimiModule )
                                $file,                  //                 . . from this template
                                $row                    //                 . . with this publication passed as the $params argument
                            ]);                         //
                        }                               //
                    }                                   //
                ?>
            </section>
            <?php                                       //
        }                                               //
    }                                                   //
                                                        // -----------------
