<?php
/**
 * -------------------------------------------------------------------------
 *
 * The snippet for rendering the administrative tools.
 *
 * -------------------------------------------------------------------------
 *
 * These system variables are available:
 *
 *     $params   = FALSE or the current publication          ( see file    tiny.news.feed/Themes/default/*-page.tpl
 *                                                             or see file tiny.news.feed/Themes/default/home.tpl
 *                                                             or see file tiny.news.feed/Themes/default/404.tpl )
 *     $cms      = your application                          ( see file mimimi.core/Routines.php -> mimimiInclude -> $cms )
 *     $folder   = relative path of the application's folder ( see file mimimi.core/Routines.php -> mimimiInclude -> $folder )
 *     $filename = relative path of this TPL file            ( see file mimimi.core/Routines.php -> mimimiInclude -> $filename )
 *     $file     = absolute path of this TPL file            ( see file mimimi.core/Routines.php -> mimimiInclude -> $file )
 *
 * -------------------------------------------------------------------------
 *
 * @package    MimimiFramework
 * @subpackage Examples / Tiny News Feed site
 * @license    GPL-2.0
 *             https://opensource.org/license/gpl-2-0/
 * @copyright  2022 MiMiMi Community
 *             https://mimimi.software/
 *
 * -------------------------------------------------------------------------
 */

    /**
     * ---------------------------------------------------------------------
     *
     * The specific tools for the publication.
     *
     * ---------------------------------------------------------------------
     */

                                                        // -----------------
    $ok = $cms->amIAdmin();                             // am I admin? ( see file tiny.news.feed/Application.php -> amIAdmin )
    if ( $ok ) {                                        // if it's true
        if ( $params ) {                                //     if there is a publication
                                                        // -----------------
            ?>
            <nav class="paginator">
                <?php                                   // -----------------
                    $listAdd = $cms->getViewers(        //         get a list of viewer names ( see file tiny.news.feed/Application.php -> getViewers )
                                   '*-add.tpl'          //         . . which have an editor template for adding
                               );                       //
                                                        // -----------------
                    mimimiModule([                      //         render a snippet       ( see file mimimi.core/Routines.php -> mimimiModule )
                        'snippets/buttons-add.tpl',     //         . . from this template ( see file tiny.news.feed/Themes/default/snippets/buttons-add.tpl )
                        $listAdd                        //         . . for this viewer list
                    ]);                                 //
                ?>

                <a class="btn tools edit"   href="<?php tinyPrintUrl($params) ?>/edit"   rel="nofollow">
                    <?php printValue(TINYFEED_INTERFACE_EDIT) ?>
                </a>

                <a class="btn tools delete" href="<?php tinyPrintUrl($params) ?>/delete" rel="nofollow">
                    <?php printValue(TINYFEED_INTERFACE_DELETE) ?>
                </a>
            </nav>
            <?php                                       // -----------------
                                                        //
        } else {                                        //     otherwise

            /**
             * -------------------------------------------------------------
             *
             * The universal tools.
             *
             * -------------------------------------------------------------
             */

                                                        // -----------------
            $listAll = $cms->getViewers(                //         get a list of viewer names ( see file tiny.news.feed/Application.php -> getViewers )
                           '*-list.tpl'                 //         . . which have a template for listing
                       );                               //
                                                        // -----------------
            $listAdd = $cms->getViewers(                //         get a list of viewer names ( see file tiny.news.feed/Application.php -> getViewers )
                           '*-add.tpl'                  //         . . which have an editor template for adding
                       );                               //
                                                        // -----------------
            if ( $listAll || $listAdd ) {               //         if anything is non-empty
                ?>
                <nav class="paginator">
                    <?php
                        mimimiModule([                  //             render a snippet       ( see file mimimi.core/Routines.php -> mimimiModule )
                            'snippets/buttons-all.tpl', //             . . from this template ( see file tiny.news.feed/Themes/default/snippets/buttons-all.tpl )
                            $listAll                    //             . . for this viewer list
                        ]);                             //
                                                        // -----------------
                        mimimiModule([                  //             render a snippet       ( see file mimimi.core/Routines.php -> mimimiModule )
                            'snippets/buttons-add.tpl', //             . . from this template ( see file tiny.news.feed/Themes/default/snippets/buttons-add.tpl )
                            $listAdd                    //             . . for this viewer list
                        ]);                             //
                    ?>
                </nav>
                <?php                                   //
            }                                           //
        }                                               //
    }                                                   //
                                                        // -----------------
