<?php
/**
 * -------------------------------------------------------------------------
 *
 * The viewer module for generating a sitemap XML document. It is always
 * called using run() method implemented below. The initiator of that call
 * is the main module of your application.
 *
 * -------------------------------------------------------------------------
 *
 * @package    MimimiFramework
 * @subpackage Examples / Five Viewers site
 * @license    GPL-2.0
 *             https://opensource.org/license/gpl-2-0/
 * @copyright  2022 MiMiMi Community
 *             https://mimimi.software/
 *
 * -------------------------------------------------------------------------
 */

    mimimiInclude ( 'Module.php' );
    class MyMimimiSitemap extends MimimiModule {

        /**
         * -----------------------------------------------------------------
         *
         * Generates the contents of SITEMAP document.
         *
         * -----------------------------------------------------------------
         *
         * Please note that due to the specifics of the app's router, this
         * method of the visual module "Sitemap" is called for any URLs
         * starting with "sitemap". However, only a single form of URL is
         * processed by this method:
         *
         *     https://your.site/sitemap
         *
         * Another forms of the locator are incorrect and are therefore
         * ignored, causing the app's router to display them later using the
         * visual module "Error404". This is what those incorrect forms look
         * like:
         *
         *     https://your.site/sitemap/UNDEFINED-OPTIONS
         *                               │               │
         *                               └──────┬────────┘
         *                                      │
         *                                      └─> it is the incoming $params
         *
         * -----------------------------------------------------------------
         *
         * @public
         * @param   mixed  $params  (optional) The rest of page's URL if detected by the app's routing method.
         * @return  bool            TRUE  if the document was rendered successfully.
         *                          FALSE if the page URL is incorrect and an Error404 page needs to be displayed.
         *
         * -----------------------------------------------------------------
         */

        public function run ( $params = '' ) {
            return   $params == ''
                && ( $data = $this->app->channels->getSitemap ( ) )
                &&           $this->app->renderTemplate       ( 'sitemap.tpl',
                                                                'Oops, this site does not have a sitemap template!',
                                                                $data );
        }
    };
