<?php /* =======================================================
|                                                              |
|   Helper for routines to be used in files of this template   |
|                                                              |
|   --------------------------------------------------------   |
|                                                              |
|   Author: MiMiMi Community                                   |
|       > www.mimimi.software                                  |
|   Licensed under CC BY 4                                     |
|       > www.creativecommons.org/licenses/by/4.0              |
|                                                              |
|   --------------------------------------------------------   |
|                                                              |
|   Input variables:                                           |
|       $folder   = Core's folder name (ended with slash)      |
|       $filename = this template filepath (relative to the    |
|                   Core's folder)                             |
|       $file     = this template's absolute filepath          |
|       $app      = Core's application object                  |
|                                                              |
============================================================= */

    /* =========================================================
    |                                                          |
    |   Start the visitor's session                            |
    |                                                          |
    ========================================================= */

    function startSession () {
        global $app;
        $app->has->session
              ? $app->session->run()
              : session_start();
    }

    /* =========================================================
    |                                                          |
    |   Get the session's parameter $PARAM                     |
    |                                                          |
    ========================================================= */

    function getSession ( $param, $def = '' ) {
        global $app;
        return $app->has->session
               ? $app->session->get($param, $def)
               : mimimiSession($param, $def);
    }

    /* =========================================================
    |                                                          |
    |   Set the session's parameter $PARAM                     |
    |                                                          |
    ========================================================= */

    function setSession ( $param, $value ) {
        global $app;
        if ($app->has->session) {
            $app->session->set($param, $value);
        } else {
            $_SESSION[$param] = $value;
        }
    }

    /* =========================================================
    |                                                          |
    |   Send status code "200 OK" to the user's browser        |
    |                                                          |
    ========================================================= */

    function sendStatus200 () {
        $scheme = mimimiServer(
            'SERVER_PROTOCOL',
            'HTTP/1.1'
        );
        @ header($scheme . ' 200 OK', TRUE, 200);
    }

    /* =========================================================
    |                                                          |
    |   Send status code "404 Not Found" to the user's browser |
    |                                                          |
    ========================================================= */

    function sendStatus404 () {
        $scheme = mimimiServer(
            'SERVER_PROTOCOL',
            'HTTP/1.1'
        );
        @ header($scheme . ' 404 Not Found', TRUE, 404);
    }

    /* =========================================================
    |                                                          |
    |   Show the website's absolute URI                        |
    |                                                          |
    ========================================================= */

    function printSiteUri () {
        mimimiSite();
        mimimiRoot();
    }

    /* =========================================================
    |                                                          |
    |   Show the current page's absolute URI                   |
    |                                                          |
    ========================================================= */

    function printPageUri () {
        mimimiSite();
        mimimiRoot();
        mimimiUri();
    }

    /* =========================================================
    |                                                          |
    |   Inform your TRAFFIC masters about $SUBJECT with $MSG   |
    |                                                          |
    ========================================================= */

    function informTraffics ( $subject, $msg ) {
        global $app;

        /* -------------------------------------
        |                                      |
        |   Prepare details                    |
        |                                      |
        ------------------------------------- */

        $details = $app->has->visitor
                   ? $app->visitor->run()
                   : array();

        /* -------------------------------------
        |                                      |
        |   Send via module if it exists       |
        |                                      |
        ------------------------------------- */

        if ($app->has->informer) {
            $app->informer->run(
                array(
                    'subject'  => $subject,
                    'message'  => $msg,
                    'email'    => MIMIMI_EMAILS_FOR_TRAFFIC_MASTER,
                    'details'  => $details
                )
            );

        /* -------------------------------------
        |                                      |
        |   Otherwise send by routine          |
        |                                      |
        ------------------------------------- */

        } else {
            mimimiInform(
                $subject,
                $msg,
                MIMIMI_EMAILS_FOR_TRAFFIC_MASTER,
                $details
            );
        }
    }

    /* =========================================================
    |                                                          |
    |   Inform your TRAFFIC masters about this visit           |
    |                                                          |
    ========================================================= */

    function informVisit ( $pageType = '' ) {
        informTraffics(
            'Visit to ' . $pageType . ' page',
            'An user has landed on the ' . $pageType . ' page.'
        );
    }

    /* =========================================================
    |                                                          |
    |   Inform your TRAFFIC masters about disabling analysis   |
    |   (that is rejecting the GDPR notice by clicking         |
    |   "Disable analysis" button)                             |
    |                                                          |
    ========================================================= */

    function informAnalysis () {
        informTraffics(
            'Reject GDPR notice',
            'An user has rejected the GDPR notice by clicking "Disable analysis" button.'
        );
    }

    /* =========================================================
    |                                                          |
    |   Block trailing injections                              |
    |                                                          |
    ========================================================= */

    return;