<?php /* =======================================================
|                                                              |
|   Template to display the page's form named FORM-2           |
|                                                              |
|   --------------------------------------------------------   |
|                                                              |
|   Author: MiMiMi Community                                   |
|       > www.mimimi.software                                  |
|   Licensed under CC BY 4                                     |
|       > www.creativecommons.org/licenses/by/4.0              |
|                                                              |
|   --------------------------------------------------------   |
|                                                              |
|   Input variables:                                           |
|       $folder   = application's folder name (ended with /)   |
|       $filename = this template filepath (relative to the    |
|                   application's folder)                      |
|       $file     = this template's absolute filepath          |
|       $app      = application's object                       |
|                                                              |
============================================================= */

    /* -----------------------------------------
    |                                          |
    |   Make the READONLY/EDITABLE attribute   |
    |   and the DISABLED/REQUIRED class for    |
    |   the INPUT 2 (see its in the HTML       |
    |   layout below, and see the related      |
    |   INPUT 3 on the previous page)          |
    |                                          |
    ----------------------------------------- */

    $param = getFlashbackPrefix() . 'folderApp';
    $input2attribute = getSession($param)
                       ? ''
                       : 'disabled';
    $input2class = $input2attribute
                   ? 'disabled'
                   : 'required';

    /* -----------------------------------------
    |                                          |
    |   Define the controlled form fields:     |
    |       name         = a field name        |
    |       value        = its initial value   |
    |       options      = list of values for  |
    |                      tag <select> in     |
    |                      format "Value" or   |
    |                      "Value|To Display"  |
    |       flashback    = TRUE if save the    |
    |                      posted field in     |
    |                      session and restore |
    |                      it on next time     |
    |       corrected    = a list of regular   |
    |                      expressions to      |
    |                      optimize the posted |
    |                      field before        |
    |                      checking for errors |
    |       required     = TRUE if the posted  |
    |                      field cannot be     |
    |                      empty               |
    |       requ..Error  = a message if this   |
    |                      field is empty      |
    |       format       = a regular expression|
    |                      to validate the     |
    |                      posted field        |
    |       formatError  = a message if this   |
    |                      field is incorrect  |
    |       cha..Message = a message if this   |
    |                      field is changed    |
    |       readonly     = TRUE if ignore this |
    |                      field and always use|
    |                      its initial value   |
    |                                          |
    |   ------------------------------------   |
    |                                          |
    |   Note: Define this variable as global   |
    |         to use below (see routines       |
    |         printFormValue, printFormError,  |
    |         and printFormChanges in the      |
    |         HELPER.PHP file).                |
    |                                          |
    ----------------------------------------- */

    global $form;
    $form = array(
        array(
            'name'           => 'themeCore',
            'value'          => MIMIMI_CORE_THEME,
            'options'        => mimimiFolders(
                                    MIMIMI_CORE_FOLDER . 'Themes'
                                ),
            'flashback'      => TRUE,
            'corrected'      => array(
                                    '/[^.a-z0-9_-]+/ui' => '-',
                                    '/\.+/u'            => '.',
                                    '/\.+$/u'           => ''
                                ),
            'required'       => TRUE,
            'requiredError'  => 'This theme is required!',
            'format'         => '/^[.a-z0-9_-]+[a-z0-9_-]?$/ui',
            'formatError'    => 'Theme name is incorrect!',
            'changedMessage' => 'Corrected by Installer. Is it right?'
        ),
        array(
            'name'           => 'themeApp',
            'value'          => MIMIMI_APP_THEME,
            'options'        => mimimiFolders(
                                    MIMIMI_APP_FOLDER . 'Themes'
                                ),
            'readonly'       => $input2attribute,
            'flashback'      => TRUE,
            'corrected'      => array(
                                    '/[^.a-z0-9_-]+/ui' => '-',
                                    '/\.+/u'            => '.',
                                    '/\.+$/u'           => ''
                                ),
            'required'       => TRUE,
            'requiredError'  => 'This theme is required!',
            'format'         => '/^[.a-z0-9_-]+[a-z0-9_-]?$/ui',
            'formatError'    => 'Theme name is incorrect!',
            'changedMessage' => 'Corrected by Installer. Is it right?'
        ),
        array(
            'name'           => 'themeInstall',
            'value'          => MIMIMI_INSTALL_THEME,
            'options'        => mimimiFolders(
                                    MIMIMI_INSTALL_FOLDER . 'Themes'
                                ),
            'readonly'       => TRUE
        )
    );

    /* -----------------------------------------
    |                                          |
    |   Do some backend logic                  |
    |       > restore (flashback) value of     |
    |         the form fields from the session |
    |       > validate posted form             |
    |       > if that form is OK               |
    |           > remember "STEP-2 is passed"  |
    |           > send soft redirect to STEP-3 |
    |           > return (break this template) |
    |       > end if                           |
    |                                          |
    |   ------------------------------------   |
    |                                          |
    |   Note: See the HELPER.PHP file to       |
    |         understand this logic.           |
    |                                          |
    ----------------------------------------- */

    flashbackForm($form);
    $ok = validateForm($form, 'submitForm2');
    if ($ok) {
        setCheckpoint('step2'); ?>

        <script>
            location.replace('<?php printSiteUri() ?>step-3')
        </script> <?php

        return;
    }

    /* =========================================================
    |                                                          |
    |   Make a content for the user                            |
    |                                                          |
    ========================================================= */

?>  <form action="<?php printPageUri() ?>" method="post">
        <fieldset>
            <legend>
                Themes
            </legend>

            <!-- -------------------------------
            |                                  |
            |   An input 1                     |
            |                                  |
            -------------------------------- -->

            <label class="size33 required">
                <span class="caption">
                    for the Core:
                </span>
                <select name="themeCore">
                    <?php printFormOptions('themeCore') ?>
                </select>
                <span class="error"><?php printFormError('themeCore') ?></span>
                <span class="changed"><?php printFormChanges('themeCore') ?></span>
            </label>

            <!-- -------------------------------
            |                                  |
            |   An input 2                     |
            |                                  |
            -------------------------------- -->

            <label class="size33 <?php printValue($input2class) ?>">
                <span class="caption">
                    for the APP:
                </span>
                <select name="themeApp"
                        <?php printValue($input2attribute) ?>>
                    <?php printFormOptions('themeApp') ?>
                </select>
                <span class="error"><?php printFormError('themeApp') ?></span>
                <span class="changed"><?php printFormChanges('themeApp') ?></span>
            </label>

            <!-- -------------------------------
            |                                  |
            |   A placeholder                  |
            |                                  |
            -------------------------------- -->

            <label class="size33 disabled">
                <span class="caption">
                    for the Installer:
                </span>
                <select name="themeInstall"
                        disabled>
                    <?php printFormOptions('themeInstall') ?>
                </select>
            </label>
        </fieldset>

        <!-- -----------------------------------
        |                                      |
        |   A remark                           |
        |                                      |
        ------------------------------------ -->

        <blockquote class="iconized">
            <svg class="icon">
                <use xlink:href="#icon-info"></use>
            </svg>

            Required fields are marked with a red dot in the corner.
            In case of an input error, a red warning will appear under
            the wrong field. If a field is corrected by the Installer,
            a green notice will appear under that field.
        </blockquote>

        <!-- -----------------------------------
        |                                      |
        |   Pagination if you need             |
        |                                      |
        ------------------------------------ -->

        <nav>
            <a class="btn" href="<?php printSiteUri() ?>step-1">
                &laquo; Back
            </a>
            <button type="submit" name="submitForm2" value="1">
                Next &raquo;
            </button>
        </nav>
    </form>
