<?php /* =======================================================
|                                                              |
|   Template to display the page's top                         |
|                                                              |
|   --------------------------------------------------------   |
|                                                              |
|   Author: MiMiMi Community                                   |
|       > www.mimimi.software                                  |
|   Licensed under CC BY 4                                     |
|       > www.creativecommons.org/licenses/by/4.0              |
|                                                              |
|   --------------------------------------------------------   |
|                                                              |
|   Input variables:                                           |
|       $folder   = application's folder name (ended with /)   |
|       $filename = this template filepath (relative to the    |
|                   application's folder)                      |
|       $file     = this template's absolute filepath          |
|       $app      = application's object                       |
|                                                              |
|   --------------------------------------------------------   |
|                                                              |
|   Global variables:                                          |
|       $post = a data of the current page:                    |
|                   'title'    => page title                   |
|                   'meta'     => page description             |
|                   'keywords' => page keywords                |
|                   ...                                        |
|                   and so on                                  |
|                                                              |
============================================================= */

?><!DOCTYPE html>
<html lang="en">
    <head>
        <base href="<?php printSiteUri() ?>">
        <meta charset="utf-8">
        <meta name="viewport" content="width=device-width, initial-scale=1.0">

        <!-- -----------------------------------
        |                                      |
        |   Canonize any variants of this URI  |
        |   into its plain variant             |
        |                                      |
        ------------------------------------ -->

        <link rel="canonical" href="<?php printPageUri() ?>">

        <!-- -----------------------------------
        |                                      |
        |   Disable any Installer's page to be |
        |   indexed by searching robots        |
        |                                      |
        ------------------------------------ -->

        <meta name="robots" content="noindex, nofollow">

        <!-- -----------------------------------
        |                                      |
        |   Meta information                   |
        |                                      |
        ------------------------------------ -->

        <title><?php printPageTitle() ?></title>
        <meta name="description" content="<?php printPageMeta() ?>">
        <meta name="keywords" content="<?php printPageKeywords() ?>">

        <!-- -----------------------------------
        |                                      |
        |   Your website icon                  |
        |                                      |
        ------------------------------------ -->

        <link rel="shortcut icon" href="<?php printSiteUri() ?>favicon.ico" type="image/ico">

        <!-- -----------------------------------
        |                                      |
        |   Insert the template's styles       |
        |                                      |
        ------------------------------------ -->

        <style>
            <?php mimimiDump('css/style.css') ?>
        </style>
    </head>

    <!-- ---------------------------------------
    |                                          |
    |   Insert the template's SVG icons        |
    |                                          |
    ---------------------------------------- -->

    <body>
        <?php mimimiDump('images/icons.svg') ?>

        <!-- -----------------------------------
        |                                      |
        |   The page header                    |
        |                                      |
        ------------------------------------ -->

        <header>
            <p>
                This is a base application to install any components
                of the MiMiMi package.
            </p>
        </header>