<?php /* =======================================================
|                                                              |
|   Template to display the MiMiMi Installer's STEP-2 page     |
|                                                              |
|   --------------------------------------------------------   |
|                                                              |
|   Author: MiMiMi Community                                   |
|       > www.mimimi.software                                  |
|   Licensed under CC BY 4                                     |
|       > www.creativecommons.org/licenses/by/4.0              |
|                                                              |
|   --------------------------------------------------------   |
|                                                              |
|   Input variables:                                           |
|       $folder   = application's folder name (ended with /)   |
|       $filename = this template filepath (relative to the    |
|                   application's folder)                      |
|       $file     = this template's absolute filepath          |
|       $app      = application's object                       |
|                                                              |
============================================================= */

    /* -----------------------------------------
    |                                          |
    |   Do some backend logic                  |
    |       > load the HELPER file             |
    |       > start the visitor's session      |
    |                                          |
    |   ------------------------------------   |
    |                                          |
    |   Note: See the HELPER.PHP file to       |
    |         understand this logic.           |
    |                                          |
    ----------------------------------------- */

    mimimiModule('helper.php');
    startSession();

    /* -----------------------------------------
    |                                          |
    |   Do some security logic                 |
    |       > if page STEP-1 is not passed     |
    |           > redirect to homepage         |
    |       > end if                           |
    |       > remember that STEP-2 isn't passed|
    |       > ... page STEP-3 is not passed    |
    |       > ... page STEP-4 is not passed    |
    |       > ... page STEP-5 is not passed    |
    |       > send status "200 OK"             |
    |                                          |
    ----------------------------------------- */

    if (hasNoCheckpoint('step1')) {
        gotoHome();
    }
    clearCheckpoint('step2');
    clearCheckpoint('step3');
    clearCheckpoint('step4');
    clearCheckpoint('step5');
    sendStatus200();

    /* -----------------------------------------
    |                                          |
    |   Simulate reading a post from database  |
    |                                          |
    ----------------------------------------- */

    global  $post;
            $post = array(
                'title'    => 'Install the MiMiMi - Theme',
                'meta'     => 'This is an installer page to choose theme for components.',
                'keywords' => 'themes page, choose themes',
                'h1'       => 'Choose the themes'
            );

    /* =========================================================
    |                                                          |
    |   Make a content for the user                            |
    |                                                          |
    ========================================================= */

    /* -----------------------------------------
    |                                          |
    |   Display the page's top                 |
    |                                          |
    ----------------------------------------- */

    mimimiModule('blocks/header.php');

?>  <!-- ---------------------------------------
    |                                          |
    |   Display the page's content             |
    |                                          |
    ---------------------------------------- -->

    <main>
        <h1>
            <strong>Step 2 of 5</strong>
            <?php printPageH1() ?>
        </h1>

        <p>
            You need to specify the frontend theme for
            each component. It is one of the themes
            located in the <em>Themes</em> folder
            of the corresponding component.
        </p>

        <!-- -----------------------------------
        |                                      |
        |   Display the form named FORM-2      |
        |                                      |
        ------------------------------------ -->

        <?php mimimiModule('blocks/form-2.php'); ?>
    </main>

<?php /* ---------------------------------------
    |                                          |
    |   Display the page's bottom              |
    |                                          |
    ----------------------------------------- */

    mimimiModule('blocks/footer.php');