<?php
/**
 * -------------------------------------------------------------------------
 *
 * Template for rendering the "Home" page.
 *
 * -------------------------------------------------------------------------
 *
 * These global variables are available:
 *     $app    = your application
 *     $params = list of newspapers to read
 *
 * -------------------------------------------------------------------------
 */

    /**
     * ---------------------------------------------------------------------
     *
     * Send headers to the user's browser.
     *
     * ---------------------------------------------------------------------
     */

    sendHeaderHTML();
    sendStatus200();
    sendHeaderExpires(
        $app->isAdmin() ? 0    // no caching if you are an admin
                        : 1    // otherwise cache for 1 hour
    );
    sendHeaderLastModified();

    /**
     * ---------------------------------------------------------------------
     *
     * Generate the page content.
     *
     * ---------------------------------------------------------------------
     */

?><!DOCTYPE html>
<html class="home" lang="<?php myPrintSetting( 'home_language' ) ?>">
    <head>
        <base href="<?php printSiteUrl() ?>">
        <meta charset="UTF-8">
        <meta name="viewport"    content="width=device-width, initial-scale=1">

        <title>
            <?php myPrintSetting( 'home_title' ) ?>
        </title>
        <meta name="description" content="<?php myPrintSetting( 'home_meta' ) ?>">
        <meta name="robots"      content="index, follow">
        <link rel="canonical"    href="<?php printSiteUrl() ?>">

        <link rel="stylesheet"   href="<?php printThemeUrl() ?>css/fonts.css">
        <link rel="stylesheet"   href="<?php printThemeUrl() ?>css/reset.css">
        <link rel="stylesheet"   href="<?php printThemeUrl() ?>css/styles.css">
    </head>

    <body>
        <div class="page">
            <div class="wrapper">
                <div class="edition">
                    <?php myPrintSetting( 'home_edition' ) ?>
                </div>

                <aside class="header">
                    <div class="wrapper">
                        <div class="number">
                            <?php myPrintSetting( 'home_number' ) ?>
                        </div>
                        <div class="date">
                            <?php myPrintToday() ?>
                        </div>
                        <div class="slogan">
                            <?php myPrintSetting( 'home_slogan' ) ?>
                        </div>
                    </div>
                </aside>

                <main class="content">
                    <?php
                        mimimiModule([
                            'snippets/list-newspapers.tpl',
                            myGetSetting( 'home_meta' ),
                            $params
                        ]);
                    ?>
                </main>

                <?php
                    /**
                     * -----------------------------------------------------
                     *
                     * Generate administrative tools.
                     *
                     * -----------------------------------------------------
                     */

                    mimimiModule(
                        'snippets/tools.tpl'
                    );
                ?>

                <aside class="footer">
                    <div class="wrapper">
                        <div class="copyright">
                            <?php myPrintSetting( 'home_copyright' ) ?>
                        </div>
                        <a class="credits" href="https://mimimi.software/" rel="nofollow noopener noreferrer" tabindex="-1">
                            Powered by MiMiMi
                        </a>
                    </div>
                </aside>
            </div>

            <?php
                /**
                 * ---------------------------------------------------------
                 *
                 * Generate some pointers to website pages.
                 *
                 * ---------------------------------------------------------
                 */

                if ( $params ) {
                    $row = reset( $params );
                    ?>
                    <aside class="signpost">
                        <a class="btn next" href="<?php printValue( $row[ 'url' ] ) ?>">
                            <?php myPrintSetting( 'button_latest' ) ?>
                        </a>
                    </aside>
                    <?php
                }
            ?>
        </div>

        <script src="<?php printThemeUrl() ?>js/scripts.js"></script>
    </body>
</html>