<?php
/**
 * -------------------------------------------------------------------------
 *
 * The template for rendering the SITEMAP.XML document of news.
 *
 * The following XML markup and program code implements templatized logic
 * that sends the required headers of the generated XML document and its
 * content to the user's browser.
 *
 * -------------------------------------------------------------------------
 *
 * How did this file run?
 *
 *     ├─> .htaccess
 *     └─> index.php
 *           ├─> tiny.news.feed/Config.php
 *           ├─> mimimi.core/Routines.php
 *           │               └─<─ routine mimimiModule()
 *           ├─> [MAKE THE $app GLOBAL VARIABLE]
 *           ├─> tiny.news.feed/Constants.php          ┌─<─ class mimimi.core/Module.php
 *           │                  ┌─<─ class mimimi.core/NodeModule.php
 *           └─> tiny.news.feed/Application.php
 *                              │    └─> run()                ┌─<─ class mimimi.core/Module.php
 *                              │         ├─> mimimi.core/Has/Has.php
 *                              │         │                         ┌─<─ class mimimi.core/Module.php
 *                              │         └─> tiny.news.feed/Router/Router.php
 *                              │                                      └─> run()
 *                              └─<─ method getSitemap()                    ├─> [MAKE THE $item GLOBAL VARIABLE  ]
 *                                                                          ├─> [MAKE THE $items GLOBAL VARIABLE ]
 *                                                                          ├─> [MAKE THE $page GLOBAL VARIABLE  ]
 *                                                                          ├─> [MAKE THE $viewer GLOBAL VARIABLE]
 *                                                                          ├─> [MAKE THE $url GLOBAL VARIABLE   ]
 *                                                                          ├─> cutViewer()            ┌─<─ class mimimi.core/Module.php
 *                                                                          │       └─> mimimi.modules/Url/Url.php
 *                                                                          │                               ├─> cutSegment()
 *                                                                          │                               └─> cutPaginator()        ┌─<─ class mimimi.core/Module.php
 *                                                                          ├─> checkFor()                     ┌─<─ class mimimi.core/NodeModule.php                     ┌─<─ class mimimi.core/Module.php
 *                                                                          │       └─> tiny.news.feed/Viewers/Viewers.php                        ┌─<─ class mimimi.core/ModuleWithTable.php
 *                                                                          │                                     └─> tiny.news.feed/Viewers/News/News.php
 *                                                                          │                                                                     └─<─ method getSitemap()
 *                                                                          └─> findMe()                     ┌─<─ class mimimi.core/Module.php
 *                                                                                 └─> tiny.news.feed/Themes/Themes.php
 *                                                                                                              ├─> checkFor()                                                    ┌─<─ class mimimi.core/Module.php
 *                                                                                                              └─> render()                     ┌─<─ class mimimi.modules/Helper/Helper.php
 *                                                                                                                     ├─> tiny.news.feed/Helper/Helper.php                       ├─<─ routine sendHeaderXML()
 *                                                                                                                     │                                                          ├─<─ routine sendStatus200()
 *                                                                                                                     │                                                          ├─<─ routine sendHeaderExpires()
 *                                                                                                                     │                                                          ├─<─ routine sendHeaderLastModified()
 *                                                                                                                     │                                                          ├─<─ routine stopIfHead()
 *                                                                                                                     │                                                          └─<─ routine printSiteUrl()
 *                                                                                                                     └─> tiny.news.feed/Themes/default/news-sitemap.tpl
 *                                                                                                                                                       │      └─> [SEND CONTENT TO THE BROWSER]
 *                                                                                                                                                       └─<─ snippet tiny.news.feed/Themes/default/snippets/sitemap.tpl
 *
 * The down-right arrows show the order in which app files are loaded and
 * their methods that are called when processing a request to the site.
 * The left-down arrows show the classes from which the corresponding
 * application file is derived. The left-up arrows show some of the public
 * routines or some of the public methods that the corresponding file
 * exposes to other application modules.
 *
 * -------------------------------------------------------------------------
 *
 * These global variables are available:
 *
 *     $item   = FALSE     ( see file tiny.news.feed/Router/Router.php -> run -> $item )
 *     $items  = FALSE     ( see file tiny.news.feed/Router/Router.php -> run -> $items )
 *     $page   = 0         ( see file tiny.news.feed/Router/Router.php -> run -> $page )
 *     $viewer = 'news'    ( see file tiny.news.feed/Router/Router.php -> run -> $viewer )
 *     $url    = 'sitemap' ( see file tiny.news.feed/Router/Router.php -> run -> $url )
 *
 * And these system variables:
 *
 *     $app      = your application                                            ( see file mimimi.core/Routines.php -> mimimiInclude -> $app )
 *     $params   = some parameters if they were passed by the calling template ( see file mimimi.core/Routines.php -> mimimiInclude -> $params )
 *     $folder   = relative path of the application's folder                   ( see file mimimi.core/Routines.php -> mimimiInclude -> $folder )
 *     $filename = relative path of this TPL file                              ( see file mimimi.core/Routines.php -> mimimiInclude -> $filename )
 *     $file     = absolute path of this TPL file                              ( see file mimimi.core/Routines.php -> mimimiInclude -> $file )
 *
 * -------------------------------------------------------------------------
 *
 * @package    MimimiFramework
 * @subpackage Examples / Tiny News Feed site
 * @license    GPL-2.0
 *             https://opensource.org/license/gpl-2-0/
 * @copyright  2022 MiMiMi Community
 *             https://mimimi.software/
 *
 * -------------------------------------------------------------------------
 */

/**
 * -------------------------------------------------------------------------
 *
 * Headers to be sent to the user's browser.
 *
 * -------------------------------------------------------------------------
 */

                                                        // -----------------
    sendHeaderXML();                                    // it is XML document            ( see file mimimi.modules/Helper/Helper.php -> sendHeaderXML )
    sendStatus200();                                    // availability status is 200 OK ( see file mimimi.modules/Helper/Helper.php -> sendStatus200 )
    sendHeaderExpires(0);                               // cache will expire immediately ( see file mimimi.modules/Helper/Helper.php -> sendHeaderExpires )
    sendHeaderLastModified();                           // last modified time equals now ( see file mimimi.modules/Helper/Helper.php -> sendHeaderLastModified )
                                                        // -----------------
    stopIfHead();                                       // stop execution if the request method is HEAD ( see file mimimi.modules/Helper/Helper.php -> stopIfHead )
                                                        // -----------------

/**
 * -------------------------------------------------------------------------
 *
 * XML content to be sent to the user's browser.
 *
 * The following code renders an XML link to the home page, and then XML
 * links to non-disabled pages associated with some $viewer identified by
 * the first segment of the requested URL. To render those $viewer links,
 * we use a special template snippet "sitemap.tpl" located in the "snippets"
 * folder of your website's theme and pass it that $viewer name.
 *
 * -------------------------------------------------------------------------
 */

?>
<?xml version="1.0" encoding="UTF-8"?>
<urlset xmlns="http://www.sitemaps.org/schemas/sitemap/0.9">
    <url>
        <loc>
            <?php                                       // -----------------
                printSiteUrl();                         // print a home page URL ( like "htpps://your.site/" )
            ?>
        </loc>
    </url>

    <?php                                               // -----------------
        global $viewer;                                 // refer to the incoming variable
        mimimiModule([                                  // render a snippet       ( see file mimimi.core/Routines.php -> mimimiModule )
            'snippets/sitemap.tpl',                     // . . from this template ( see file tiny.news.feed/Themes/default/snippets/sitemap.tpl )
            $viewer                                     // . . for this viewer name
        ]);                                             //
    ?>
</urlset>