<?php
/**
 * -------------------------------------------------------------------------
 *
 * The class for the default application.
 *
 * -------------------------------------------------------------------------
 *
 * Look at this diagram to understand how the app works:
 *
 *     ├─> .htaccess
 *     │
 *     │   ┌─<─ constant ...
 *     │   │
 *     │   ├─<─ routine mimimiLoad()
 *     │   │
 *     └─> index.php
 *           │
 *           ├─> mimimi.core/Config.php
 *           │               │
 *           │               ├─<─ constant MIMIMI_CORE_THEME
 *           │               └─<─ constant ...
 *           │
 *           ├─> mimimi.core/RoutinesSystem.php
 *           │               │
 *           │               ├─<─ constant ...
 *           │               │
 *           │               ├─<─ routine mimimiInclude()
 *           │               └─<─ routine ...
 *           │
 *           │   ┌───────────────────────────────┐
 *           ├─> │ MAKE THE $app GLOBAL VARIABLE │
 *           │   └───────────────────────────────┘
 *           │
 *           │                                      ┌─<─ class mimimi.core/Module.php
 *           │                                      │                      │ └─> __construct()
 *           │                                      │                      │
 *           │                                      │                      ├─<─ property $owner
 *           │                                      │                      ├─<─ property $app
 *           │                                      │                      │
 *           │               ┌─<─ class mimimi.core/NodeModule.php         └─<─ method run()
 *           │               │                      │    └─> __construct()*
 *           │               │                      │
 *           │               │                      ├─<─ property $myNodeFile
 *           └─> mimimi.core/Application.php        │
 *                                │                 ├─<─ method __get()
 *                                └─> run()*        └─<─ method getNodePath()
 *                                     │
 *                                     ├─<─ mimimi.core/RoutinesWeb.php
 *                                     │                │
 *                                     │                ├─<─ constant ...
 *                                     │                │
 *                                     │                ├─<─ routine mimimiModule()
 *                                     │                └─<─ routine ...
 *                                     │
 *                                     │   ┌───────────────────────────────────────────────────────────────────┐
 *                                     └─> │ RENDER TEMPLATE mimimi.core/Themes/[ MIMIMI_CORE_THEME ]/home.php │
 *                                         └──────────────────────────────────────────┬────────────────────────┘
 *                                                                                    │
 *                                              ┌─────────────────────────────────┐   │
 *                                              │ SEND HTML TO THE USER'S BROWSER │ <─┘
 *                                              └─────────────────────────────────┘
 *
 * The right arrows show the order in which application files are loaded and
 * their methods that are called when processing a request to this app. The
 * left arrows show the class from which the corresponding application file
 * is derived. They also show some public routines, some public methods, or
 * some constants that the corresponding file exposes to other application
 * modules. The method or property that has been overridden is marked with
 * an asterisk.
 *
 * -------------------------------------------------------------------------
 *
 * Overridden methods below are:
 *     run ( $params )  -->  to launch this app
 *
 * -------------------------------------------------------------------------
 *
 * @package    MimimiFramework
 * @subpackage Core
 * @copyright  2022 MiMiMi Community
 *             https://mimimi.software/
 * @license    GPL-2.0
 *             https://opensource.org/license/gpl-2-0/
 *
 * -------------------------------------------------------------------------
 */

    mimimiInclude ( 'NodeModule.php' );

    class MimimiApplication extends MimimiNodeModule {

        /**
         * -----------------------------------------------------------------
         *
         * Launches this module.
         *
         * -----------------------------------------------------------------
         *
         * It renders the page at the current URL, that is it generates HTML
         * content based on the homepage template.
         *
         * -----------------------------------------------------------------
         *
         * @public
         * @param   mixed  $params  (optional) Some parameters from the calling process.
         * @return  void
         *
         * -----------------------------------------------------------------
         */

        public function run ( $params = '' ) {
            mimimiLoad   ( 'RoutinesWeb.php' );

            mimimiModule ( 'home.tpl', TRUE  );
        }
    };
