<?php
/**
 * -------------------------------------------------------------------------
 *
 * Template for rendering a STEP-3 page.
 *
 * -------------------------------------------------------------------------
 */

    /**
     * ---------------------------------------------------------------------
     *
     * Do some backend logic:
     *     load HELPER file
     *     start session
     *
     * ---------------------------------------------------------------------
     */

    mimimiModule ( 'helper.tpl' );

    startSession ( );

    /**
     * ---------------------------------------------------------------------
     *
     * Do some security logic:
     *     if page STEP-2 is not passed
     *         redirect to homepage
     *     remember that page STEP-3 is not passed
     *     ............. page STEP-4 is not passed
     *     send status "200 OK"
     *
     * ---------------------------------------------------------------------
     */

    if ( hasNoCheckpoint ( 'step2' ) ) {
        gotoHome ( );
    }
    clearCheckpoint ( 'step3' );
    clearCheckpoint ( 'step4' );

    sendStatus200 ( );

    /**
     * ---------------------------------------------------------------------
     *
     * Simulate a post retrieved from the database.
     *
     * ---------------------------------------------------------------------
     */

    global  $post;
            $post = [
                'title' => 'Install the MiMiMi - Modules',
                'meta'  => 'This is an installer page to choose which modules to be installed.',
                'h1'    => 'Choose the modules'
            ];

    /**
     * ---------------------------------------------------------------------
     *
     * Generate page content.
     *
     * ---------------------------------------------------------------------
     */

?>  <?php mimimiModule ( 'blocks/header.tpl' ) ?>
    <main>
        <h1>
            <strong>Step 3 of 4</strong>
            <?php printPageH1 ( ) ?>
        </h1>
        <p>You need to choose which modules to be installed.</p>
        <?php mimimiModule ( 'blocks/form-3.tpl' ) ?>
    </main>
    <?php mimimiModule ( 'blocks/footer.tpl' ) ?>
