<?php
/**
 * -------------------------------------------------------------------------
 *
 * The snippet for rendering the document head.
 *
 * -------------------------------------------------------------------------
 *
 * These system variables are available:
 *
 *     $params   = the current publication                   ( see file    tiny.news.feed/Themes/default/home.tpl
 *                                                             or see file tiny.news.feed/Themes/default/*-page.tpl
 *                                                             or see file tiny.news.feed/Themes/default/*-list.tpl
 *                                                             or see file tiny.news.feed/Themes/default/*-add.tpl
 *                                                             or see file tiny.news.feed/Themes/default/*-delete.tpl
 *                                                             or see file tiny.news.feed/Themes/default/*-edit.tpl
 *                                                             or see file tiny.news.feed/Themes/default/404.tpl )
 *     $app      = your application                          ( see file mimimi.core/Routines.php -> mimimiInclude -> $app )
 *     $folder   = relative path of the application's folder ( see file mimimi.core/Routines.php -> mimimiInclude -> $folder )
 *     $filename = relative path of this TPL file            ( see file mimimi.core/Routines.php -> mimimiInclude -> $filename )
 *     $file     = absolute path of this TPL file            ( see file mimimi.core/Routines.php -> mimimiInclude -> $file )
 *
 * -------------------------------------------------------------------------
 *
 * @package    MimimiFramework
 * @subpackage Examples / Tiny News Feed site
 * @license    GPL-2.0
 *             https://opensource.org/license/gpl-2-0/
 * @copyright  2022 MiMiMi Community
 *             https://mimimi.software/
 *
 * -------------------------------------------------------------------------
 */

?>
<head>
    <base href="<?php printSiteUrl() ?>">
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1">

    <!-- ---------------------------------------
    *                                          *
    * Information for crawlers.                *
    *                                          *
    ---------------------------------------- -->

    <title>
        <?php printItemField('title', $params) ?>
    </title>
    <meta name="description" content="<?php printItemField('meta', $params) ?>">
    <meta name="robots"      content="<?php tinyPrintRobots($params) ?>">
    <link rel="canonical"    href="<?php tinyPrintUrl($params) ?>">

    <!-- ---------------------------------------
    *                                          *
    * The page icon and design styles.         *
    *                                          *
    ---------------------------------------- -->

    <link rel="shortcut icon" href="<?php printThemeUrl() ?>images/favicon.ico" type="image/ico">
    <link rel="stylesheet"    href="<?php printThemeUrl() ?>css/styles.css"     media="all">
</head>
