<?php
/**
 * -------------------------------------------------------------------------
 *
 * Template for rendering a page at an incorrect URL.
 *
 * -------------------------------------------------------------------------
 *
 * The first lines of this template pass the necessary headers to the user's
 * browser. To do this, routines such as "sendHeaderHTML", "sendStatus404",
 * "sendHeaderExpires", and "stopIfHead" are used. They are implemented in
 * the "Helper" system module. It is located in "mimimi.modules/Helper/Helper.php"
 * file.
 *
 * The next lines generate a page content. Two routines used here are
 * "printSiteUrl" and "printThemeUrl". They are also implemented in the
 * "Helper" module.
 *
 * -------------------------------------------------------------------------
 */

    sendHeaderHTML    (   );
    sendStatus404     (   );
    sendHeaderExpires ( 0 );
    stopIfHead        (   );

?><!DOCTYPE html>
<html lang="en-US" class="error404-page">
    <head>
        <base href="<?php printSiteUrl ( ) ?>">
        <meta charset="UTF-8">
        <meta name="viewport" content="width=device-width, initial-scale=1">
        <meta name="robots"   content="noindex">
        <title>
            Page not found / Five Viewers demo
        </title>
        <link rel="stylesheet"    href="<?php printThemeUrl ( ) ?>css/styles.css">
        <link rel="shortcut icon" href="<?php printThemeUrl ( ) ?>images/favicon.ico" type="image/ico">
    </head>

    <body>
        <div class="page">
            <?php mimimiModule ( 'snippets/header.tpl' ) ?>
            <?php mimimiModule ( 'snippets/menu.tpl'   ) ?>

            <main class="content">
                <section class="message modal">
                    <h1>Page is not found!</h1>
                    <p>Oops, something went wrong! There is no such page on this site.</p>
                    <nav class="buttons">
                        <a class="btn" href="<?php printSiteUrl ( ) ?>">
                            Close
                        </a>
                    </nav>
                </section>
            </main>

            <aside class="hint">
                <h6>To developer</h6>
                <p>If you want to learn how the <b>Error404</b> page works, please see these files:</p>
                <ul>
                    <li>
                        <u>Application.php</u>
                        <ul>
                            <li>
                                <u>mimimi.core/Website.php</u>
                                <ul>
                                    <li>
                                        <u>mimimi.core/Application.php</u>
                                        <ul>
                                            <li>
                                                <u>mimimi.core/NodeModule.php</u>
                                                <ul>
                                                    <li><u>mimimi.core/Module.php</u></li>
                                                </ul>
                                            </li>
                                        </ul>
                                    </li>
                                    <li>
                                        <u>mimimi.modules/Url/Url.php</u>
                                        <ul>
                                            <li><u>mimimi.core/Module.php</u></li>
                                        </ul>
                                    </li>
                                    <li>
                                        <u>mimimi.modules/Helper/Helper.php</u>
                                        <ul>
                                            <li><u>mimimi.core/Module.php</u></li>
                                        </ul>
                                    </li>
                                    <li><u>mimimi.core/Routines.php</u></li>
                                </ul>
                            </li>
                        </ul>
                    </li>
                    <li>
                        <u>Error404/Error404.php</u>
                        <ul>
                            <li><u>mimimi.core/Module.php</u></li>
                        </ul>
                    </li>
                    <li>
                        <u>Themes/default/error-404.tpl</u>
                        <ul>
                            <li><u>Themes/default/snippets/header.tpl</u></li>
                            <li><u>Themes/default/snippets/menu.tpl</u></li>
                            <li><u>Themes/default/snippets/footer.tpl</u></li>
                            <li><u>Themes/default/css/styles.css</u></li>
                            <li><u>Themes/default/js/scripts.js</u></li>
                            <li><u>Themes/default/images/favicon.ico</u></li>
                        </ul>
                    </li>
                </ul>
            </aside>

            <?php mimimiModule ( 'snippets/footer.tpl' ) ?>
        </div>
        <script src="<?php printThemeUrl ( ) ?>js/scripts.js"></script>
    </body>
</html>
