<?php
/**
 * -------------------------------------------------------------------------
 *
 * The base class MimimiCollection that has been extended for this app.
 *
 * -------------------------------------------------------------------------
 *
 * @package    MimimiFramework
 * @subpackage Examples / IDE skeleton
 * @license    GPL-2.0
 *             https://opensource.org/license/gpl-2-0/
 * @copyright  2022 MiMiMi Community
 *             https://mimimi.software/
 *
 * -------------------------------------------------------------------------
 */

    mimimiInclude ( 'Collection.php'  );

    class MyMimimiCollection extends MimimiCollection {

        /**
         * -----------------------------------------------------------------
         *
         * Finds a nested module if it has a method and is associated with the URL.
         *
         * -----------------------------------------------------------------
         *
         * @protected
         *
         * -----------------------------------------------------------------
         */

        protected function findModule ( & $url, $method = '' ) {
            if ( $url ) {
                $module = $this;
                $segments = preg_split ( '~/~u', $url );
                do {
                    $name = array_shift ( $segments );
                    if ( ! $module->has->$name ) {
                        array_unshift ( $segments, $name );
                        break;
                    } else if ( ! method_exists ( $module->$name, 'checkFor' ) ) {
                        $module = $module->$name;
                        break;
                    }
                    $module = $module->$name;
                } while ( $segments );
                if ( $module !== $this ) {
                    if ( $method == ''
                    ||   method_exists ( $module, $method ) ) {
                        $url = implode ( '/', $segments );
                        return $module;
                    }
                }
            }
            return FALSE;
        }

        /**
         * -----------------------------------------------------------------
         *
         * Gets a linkmap for the module using its callback method.
         *
         * -----------------------------------------------------------------
         *
         * @protected
         *
         * -----------------------------------------------------------------
         */

        protected function getMapFor ( $module, $baseUrl, $method = 'getMapItems' ) {
            $map    = [ ];
            $submap = & $map;
            if ( $module !== $this ) {
                if ( ! method_exists ( $module, $method              )
                ||   ! ( $map =        $module->$method ( $baseUrl ) ) ) return [ ];
                $index = array_key_last ( $map );
                if ( empty ( $map[ $index ][ 'subitems' ] ) ) $map[ $index ][ 'subitems' ] = [ ];
                $submap = &  $map[ $index ][ 'subitems' ];
            }
            if ( method_exists ( $module, 'listModules' ) ) {
                $names = $module->listModules ( );
                foreach ( $names as $modname => $dirname ) {
                    $items = $this->getMapFor ( $module->$modname         ,
                                                $baseUrl . $modname . '/' ,
                                                $method                   );
                    $submap = array_merge ( $submap, $items );
                }
            }
            return $map;
        }
    };
