<?php
/**
 * -------------------------------------------------------------------------
 *
 * Module to request pages attached to the "File" submenu.
 *
 * -------------------------------------------------------------------------
 *
 * @package    MimimiFramework
 * @subpackage Examples / IDE skeleton
 * @license    GPL-2.0
 *             https://opensource.org/license/gpl-2-0/
 * @copyright  2022 MiMiMi Community
 *             https://mimimi.software/
 *
 * -------------------------------------------------------------------------
 */

    mimimiInclude ( 'Collection.php' );

    class MyMimimiMenuFile extends MimimiCollection {

        /**
         * -----------------------------------------------------------------
         *
         * Gets a map of pages treated as the "File" menu item.
         *
         * -----------------------------------------------------------------
         *
         * @public
         * @param   string  $base  The base path of the menu item to compose its "url" field.
         * @return  array          ARRAY       to display this menu item(s).
         *                         EMPTY ARRAY if it doesn't need to be displayed.
         *
         * -----------------------------------------------------------------
         */

        public function getMapItems ( $base ) {
            return [ 'file' => [ 'name'     => 'File',
                                 'shortcut' => 'h',
                                 'toolicon' => '<svg xmlns="http://www.w3.org/2000/svg" height="24px" viewBox="0 -960 960 960" width="24px"><path d="M240-200h120v-240h240v240h120v-360L480-740 240-560v360Zm-80 80v-480l320-240 320 240v480H520v-240h-80v240H160Zm320-350Z"/></svg>',
                                 'url'      => $base . '../..',
                                 'title'    => 'You may click here to go to the home page of your IDE.',
                                 'subitems' => [ 'new'    => NULL ,
                                                 'open'   => NULL ,
                                                 'save'   => NULL ,
                                                 'close'  => NULL ,
                                                 'login'  => NULL ,
                                                 'logout' => NULL ] ] ];
        }             

        /**
         * -----------------------------------------------------------------
         *
         * Renders a page associated with this menu item.
         *
         * -----------------------------------------------------------------
         *
         * @public
         * @param   string  $params  The rest of the menu item URL if it has parameters.
         * @return  bool             Always FALSE, meaning there is no page for this item.
         *
         * -----------------------------------------------------------------
         */

        public function run ( $params = '' ) {
            return FALSE;
        }

        /**
         * -----------------------------------------------------------------
         *
         * Checks if the menu item is already activated.
         *
         * -----------------------------------------------------------------
         *
         * This method applies to multiple child modules. It serves to
         * determine whether any project is currently open. The method is
         * placed here to optimize the program code, since it is the same
         * for several child modules at once and there is no sense to repeat
         * this method in each of them.
         *
         * -----------------------------------------------------------------
         *
         * @public
         * @return  bool
         *
         * -----------------------------------------------------------------
         */

        public function isActive ( ) {
            $data = $this->app->projects->getProject ( );
            return ! empty ( $data[ 'dir' ] );
        }

        /**
         * -----------------------------------------------------------------
         *
         * Reset the namespace simulator if you want to provide an ability
         * to extend this menu with submenu items using child modules.
         *
         * -----------------------------------------------------------------
         *
         * @var    string
         * @access protected
         *
         * -----------------------------------------------------------------
         */

        protected $myNodeFile = __FILE__;
    };
