<?php
/**
 * -------------------------------------------------------------------------
 *
 * Module for serving the menu item "File -> Exit".
 *
 * -------------------------------------------------------------------------
 *
 * @package    MimimiFramework
 * @subpackage Examples / IDE skeleton
 * @license    GPL-2.0
 *             https://opensource.org/license/gpl-2-0/
 * @copyright  2022 MiMiMi Community
 *             https://mimimi.software/
 *
 * -------------------------------------------------------------------------
 */

    mimimiInclude ( 'Module.php' );

    class MyMimimiMenuFileLogout extends MimimiModule {

        /**
         * -----------------------------------------------------------------
         *
         * Gets a map of pages treated as the menu item "File -> Exit".
         *
         * -----------------------------------------------------------------
         *
         * @public
         * @param   string  $base  The base path of the menu item to compose its "url" field.
         * @return  array          ARRAY       to display this menu item(s).
         *                         EMPTY ARRAY if it doesn't need to be displayed.
         *
         * -----------------------------------------------------------------
         */

        public function getMapItems ( $base ) {
            return [ 'logout' => [ 'name'     => 'Exit',
                                   'shortcut' => 'e',
                                   'inactive' => ! $this->app->checkForAdmin ( ),
                                   'toolicon' => '<svg xmlns="http://www.w3.org/2000/svg" height="24px" viewBox="0 -960 960 960" width="24px"><path d="M200-120q-33 0-56.5-23.5T120-200v-560q0-33 23.5-56.5T200-840h280v80H200v560h280v80H200Zm440-160-55-58 102-102H360v-80h327L585-622l55-58 200 200-200 200Z"/></svg>',
                                   'url'      => $base,
                                   'title'    => 'Closes the current IDE session.' ] ];
        }

        /**
         * -----------------------------------------------------------------
         *
         * Renders a page associated with this menu item.
         *
         * -----------------------------------------------------------------
         *
         * @public
         * @param   string  $params  The rest of the menu item URL if it has parameters.
         *                           For example, when you visit a URL like this
         *                           https://your.site/menu/file/exit/UNEXPECTED-PARAMETERS
         *                                                            └────────┬──────────┘
         *                                                                     └─> here's what will become the incoming $params
         * @return  bool             TRUE  if the page was rendered successfully.
         *                           FALSE if there is no template file for this page.
         *                           FALSE if the menu item URL contains unexpected parameters.
         *
         * -----------------------------------------------------------------
         */

        public function run ( $params = '' ) {
            return $params == ''
                            ? $this->app->renderPage ( 'file/exit.tpl' )
                            : FALSE;
        }
    };
