<?php
/**
 * -------------------------------------------------------------------------
 *
 * Snippet for rendering the contents of the page "Topmenu -> File -> New -> Project".
 *
 * -------------------------------------------------------------------------
 */

    /**
     * ---------------------------------------------------------------------
     *
     * Execute a server logic according to the type of the current page.
     *
     * ---------------------------------------------------------------------
     */

    $error   = '';
    $success = '';

    /**
     * ---------------------------------------------------------------------
     *
     * Should we start with the second screen or do we need the first one?
     *
     * ---------------------------------------------------------------------
     */

    $directory = '';
    $screen    = helperHasProject ( )
                          ? 1
                          : 2;

    /**
     * ---------------------------------------------------------------------
     *
     * If the input form on the first screen was submitted.
     *
     * ---------------------------------------------------------------------
     */

    if ( getFormInput ( 'sure' ) ) {
        $screen = 2;

        /**
         * -----------------------------------------------------------------
         *
         * If the input form on the second screen was submitted.
         *
         * -----------------------------------------------------------------
         */

        if ( getFormInput ( 'submit' ) ) {

            /**
             * -------------------------------------------------------------
             *
             * Get the entered directory name.
             *
             * -------------------------------------------------------------
             */

            $directory = getFormInput ( 'directory' );
            $directory = mimimiSafePath ( $directory, TRUE );
            if ( $directory ) {

                /**
                 * ---------------------------------------------------------
                 *
                 * It must be alphanumeric.
                 *
                 * ---------------------------------------------------------
                 */

                $other = preg_match ( '~[^\da-z._-]~ui', $directory );
                if ( ! $other ) {

                    /**
                     * -----------------------------------------------------
                     *
                     * It must be unique.
                     *
                     * -----------------------------------------------------
                     */

                    $names  = helperListProjects ( );
                    $index  = mb_strtolower ( $directory, 'UTF-8' );
                    $exists = isset ( $names [ $index ] );
                    if ( ! $exists ) {

                        /**
                         * -------------------------------------------------
                         *
                         * Create the project directory.
                         *
                         * -------------------------------------------------
                         */

                        if ( helperHasProduction ( ) ) {
                            helperCreateProject ( $directory );
                            $screen = 3;

                        /**
                         * -------------------------------------------------
                         *
                         * Otherwise, prepare an error message.
                         *
                         * -------------------------------------------------
                         */

                        } else {
                            $success = 'Sorry, you are currently in demo mode. Any create/add/edit/delete operation is only simulated in this mode. To see how it really works, download this package and install it on your site or localhost.';
                        }
                    } else {
                        $error = 'Sorry, a project with the same name already exists. Please enter another name.';
                    }
                } else {
                    $error = 'Only alphanumeric characters, hyphen, underscore, and period can be used in the directory name.';
                }
            } else {
                $error = 'The Directory field below is required.';
            }
        }
    }

    /**
     * ---------------------------------------------------------------------
     *
     * Generate snippet content.
     *
     * ---------------------------------------------------------------------
     */

    switch ( $screen ) {

        /**
         * -----------------------------------------------------------------
         *
         * On the first screen, we only ask the user if he is sure about his
         * action.
         *
         * -----------------------------------------------------------------
         */

        case 1:
             ?>
             <form class="modal notification" action="<?php printPageUrl ( ) ?>" method="post">
                 <h1>New Project</h1>
                 <p>You currently have another project open. If you continue, the changes you made will be lost. Are you sure?</p>

                 <footer class="buttons">
                     <button class="btn" name="sure" type="submit" value="1">SURE</button>
                     <button class="btn" onclick="app.closeWindow ( this )"   >NO</button>
                 </footer>
             </form>
            <?php
            break;

        /**
         * -----------------------------------------------------------------
         *
         * On the second screen, we ask the user to enter project details.
         *
         * -----------------------------------------------------------------
         */

        case 2:
             ?>
             <form class="modal notification" action="<?php printPageUrl ( ) ?>" method="post">
                 <div class="error"  ><?php printValue ( $error   ) ?></div>
                 <div class="success"><?php printValue ( $success ) ?></div>

                 <h1>New Project</h1>
                 <p>Enter a directory name where the new project will be located.</p>
                 <label>
                     <small>Directory</small>
                     <input type="text" name="directory" value="<?php printValue ( $directory ) ?>" max-length="50" required>
                 </label>

                 <input name="sure" type="hidden" value="1">

                 <footer class="buttons">
                     <button class="btn" name="submit" type="submit" value="1">OK</button>
                     <button class="btn" onclick="app.closeWindow ( this )"   >CANCEL</button>
                 </footer>
             </form>
            <?php
            break;

        /**
         * -----------------------------------------------------------------
         *
         * On the third screen, we just save the name of the created project
         * in the browser session (local storage) and redirect the user to
         * the home page.
         *
         * Please note that this script runs before the page's main script
         * is loaded. That's why we don't use the "app.session" property and
         * its methods "setItem" and "removeItem" here.
         *
         * -----------------------------------------------------------------
         */

        case 3:
        default:
             ?>
             <script>
                 localStorage.setItem ( 'project', '<?php printValue ( $directory ) ?>' );
                 localStorage.removeItem ( 'lastTab-project' );
                 localStorage.removeItem ( 'editor-project'  );
                 window.location.replace ( '<?php printSiteUrl ( ) ?>' )
             </script>
             <?php
    }
