<?php
/**
 * -------------------------------------------------------------------------
 *
 * Snippet for rendering the contents of the page "Topmenu -> File -> Open -> File".
 *
 * -------------------------------------------------------------------------
 */

    /**
     * ---------------------------------------------------------------------
     *
     * Execute a server logic according to the type of the current page.
     *
     * ---------------------------------------------------------------------
     */

    $error     = '';
    $success   = '';
    $file      = '';
    $extension = '.' . preg_replace ( '~\|~u'                       ,
                                      ', .'                         ,
                                      helperFileExtensions ( TRUE ) );
    $screen    = 1;

    /**
     * ---------------------------------------------------------------------
     *
     * If the input form was submitted.
     *
     * ---------------------------------------------------------------------
     */

    if ( getFormInput ( 'submit' ) ) {

        /**
         * -----------------------------------------------------------------
         *
         * Get the entered file path and name.
         *
         * -----------------------------------------------------------------
         */

        $test = getFormFile ( 'file', TRUE, 0 );
        if ( $test ) {

            $file = mimimiFiles ( 'file' );
            $uploaded = 0;

            /**
             * -------------------------------------------------------------
             *
             * It must be alphanumeric path and file name.
             *
             * -------------------------------------------------------------
             */

            $pattern1 = helperFilePattern ( TRUE );
            $pattern2 = helperFilePattern (      );

            foreach ( $file[ 'error' ] as $index => $status ) {
                $name = $file[ 'name' ][ $index ];
                if ( $status == 0 ) {

                    if ( preg_match ( $pattern1, $name ) ) {

                        /**
                         * -------------------------------------------------
                         *
                         * It must be unique.
                         *
                         * -------------------------------------------------
                         */

                        if ( ! helperHasFile ( $name ) ) {
                            $uploaded++;

                            /**
                             * ---------------------------------------------
                             *
                             * Upload the project file.
                             *
                             * ---------------------------------------------
                             */

                            if ( helperHasProduction ( ) ) {
                                if ( preg_match ( $pattern2, $name ) ) {
                                    helperCreateFile ( $name, @ file_get_contents (
                                                                    $file[ 'tmp_name' ][ $index ]
                                                                ) );
                                } else {
                                    helperUploadFile ( $name,
                                                       $file[ 'tmp_name' ][ $index ] );
                                }
                                $screen = 2;

                            /**
                             * ---------------------------------------------
                             *
                             * Otherwise, prepare an error message.
                             *
                             * ---------------------------------------------
                             */

                            } else {
                                $success = 'Sorry, you are currently in demo mode. Any create/add/edit/delete operation is only simulated in this mode. To see how it really works, download this package and install it on your site or localhost.';
                            }
                        } else {
                            $error = 'Sorry, the current project already contains a file "' . $name . '". Please upload a file with another name.';
                        }
                    } else {
                        $error = 'You are trying to upload a file "' . $name . '". However, the path and file name can only contain alphanumeric characters, hyphens, underscores, and periods. Path segments must be separated by slashes. The file name must have a valid extension: ' . $extension . '.';
                    }
                } else {
                    $error = 'An error occurred while uploading the file "' . $name . '".';
                }
            }
            if ( $uploaded ) $error = '';
        } else {
            $error = 'The File(s) field below must contain at least one selected file.';
        }
    }

    /**
     * ---------------------------------------------------------------------
     *
     * Generate snippet content.
     *
     * ---------------------------------------------------------------------
     */

    switch ( $screen ) {

        /**
         * -----------------------------------------------------------------
         *
         * On the first screen, we ask the user to enter file details.
         *
         * -----------------------------------------------------------------
         */

        case 1:
             ?>
             <form class="modal notification" action="<?php printPageUrl ( ) ?>" method="post" enctype="multipart/form-data">
                 <div class="error"  ><?php printValue ( $error   ) ?></div>
                 <div class="success"><?php printValue ( $success ) ?></div>

                 <h1>Upload File</h1>
                 <p>Drag one or more files you need into the drop zone below. Or just click this zone to select files.</p>
                 <label>
                     <small>File(s)</small>
                     <div class="dropzone" ondrop="app.dropFiles      ( this )"
                                           ondragenter="app.dragFiles ( this )"
                                           ondragover="app.dragFiles  ( this )">
                         <span>
                             Drop Zone
                             <span class="count"></span>
                         </span>
                     </div>
                     <input name="file[]" type="file"
                                          multiple
                                          accept="<?php printValue ( $extension ) ?>"
                                          onchange="app.changeFiles ( this )">
                     <small>Allowed file extensions are: <?php printValue ( $extension ) ?>. Other files will be ignored.</small>
                 </label>

                 <footer class="buttons">
                     <button class="btn" name="submit" type="submit" value="1">UPLOAD</button>
                     <button class="btn" onclick="app.closeWindow ( this )"   >CANCEL</button>
                 </footer>
             </form>
            <?php
            break;

        /**
         * -----------------------------------------------------------------
         *
         * On the second screen, we just redirect the user to the home page.
         *
         * -----------------------------------------------------------------
         */

        case 2:
        default:
             mimimiModule ( 'snippets/go-home.tpl' );
    }
