<?php
/**
 * -------------------------------------------------------------------------
 *
 * The starting point of website to load and launch your application.
 *
 * -------------------------------------------------------------------------
 *
 * @package    MimimiFramework
 * @license    GPL-2.0
 *             https://opensource.org/license/gpl-2-0/
 * @copyright  2022 MiMiMi Community
 *             https://mimimi.software/
 *
 * -------------------------------------------------------------------------
 */

    /**
     * ---------------------------------------------------------------------
     *
     * Define system constants.
     *
     * ---------------------------------------------------------------------
     */

    define('MIMIMI_CORE_VERSION',   '7.1 - 2024.11.02');

    define('MIMIMI_CORE_FOLDER',    'mimimi.core/');
    define('MIMIMI_MODULES_FOLDER', 'mimimi.modules/');
    define('MIMIMI_APP_FOLDER',     'mimimi.app/');
    define('MIMIMI_INSTALL_FOLDER', 'mimimi.install/');

    /**
     * ---------------------------------------------------------------------
     *
     * Define a first system routine to load PHP files by plan.
     *
     * ---------------------------------------------------------------------
     *
     * Please note that these varaibles will be available in all loaded
     * files:
     *
     *     $plan       -->  all planned file names
     *     $locations  -->  list of relative directory names to search for planned files
     *     $filename   -->  name of the current file according to the plan
     *     $folder     -->  relative name of the directory where that file was found
     *     $file       -->  relative name of that file
     *
     * ---------------------------------------------------------------------
     *
     * @public
     * @param   array|string  $plan  ARRAY  A list of files being loaded.
     *                               STRING A name of the file being loaded.
     * @return  void
     *
     * ---------------------------------------------------------------------
     */

    function mimimiLoad ( $plan ) {
        $plan = ( array ) $plan;
        foreach ( $plan as $filename ) {
            $locations = [
                MIMIMI_INSTALL_FOLDER,
                MIMIMI_APP_FOLDER,
                MIMIMI_CORE_FOLDER
            ];
            foreach ( $locations as $folder ) {
                $file = $folder . $filename;
                if ( file_exists ( $file ) ) {
                    include_once ( $file );
                    break;
                }
            }
        }
    };

    /**
     * ---------------------------------------------------------------------
     *
     * Load a minimum required files.
     *
     * ---------------------------------------------------------------------
     */

    mimimiLoad ( [ 'Config.php',
                   'RoutinesSystem.php' ] );

    /**
     * ---------------------------------------------------------------------
     *
     * Launch the application.
     *
     * ---------------------------------------------------------------------
     */
    global $app;
           $app = mimimiCreate ( 'application' );
           $app->run ( );
