<?php
/**
 * -------------------------------------------------------------------------
 *
 * Template for rendering a home page.
 *
 * -------------------------------------------------------------------------
 */

    /**
     * ---------------------------------------------------------------------
     *
     * Do some backend logic:
     *     load HELPER file
     *     start session
     *     what is requested?
     *         when "Disable analysis"
     *             save state in session
     *             send response "OK"
     *         otherwise
     *             send status "200 OK"
     *
     * ---------------------------------------------------------------------
     */

    mimimiModule ( 'helper.tpl', TRUE );

    startSession ( );

    switch ( mimimiRequest ( 'action' ) ) {
        case 'disable':
             setSession ( 'noAnalysis', TRUE );
             mimimiStop ( 'OK', 200 );
        default:
             sendStatus200 ( );
    }

    /**
     * ---------------------------------------------------------------------
     *
     * Generate page content.
     *
     * ---------------------------------------------------------------------
     */

?><!DOCTYPE html>
<html lang="en">
    <head>
        <base href="<?php printSiteUri ( ) ?>">
        <meta charset="utf-8">
        <meta name="viewport" content="width=device-width, initial-scale=1.0">

        <link rel="canonical" href="<?php printSiteUri ( ) ?>">
        <meta name="robots" content="noindex, nofollow">
        <title>
            Hello World
        </title>
        <meta name="description" content="It is a home page which demonstrate how this framework works.">

        <link rel="shortcut icon" href="<?php printSiteUri ( ) ?>favicon.ico" type="image/ico">
        <style>
            <?php mimimiDump ( 'css/style.css', TRUE ) ?>
        </style>
    </head>

    <body>
        <?php mimimiDump ( 'images/icons.svg', TRUE ) ?>

        <header>
            <p>This is an example illustrating a simple application with European GDPR support.</p>
        </header>

        <main>
            <h1>Hello World!</h1>

            <p>Welcome to the MiMiMi framework (version <em><?php echo MIMIMI_CORE_VERSION ?></em>). It is a lightweight software package for easy website development.</p>

            <p class="iconized">
                <svg class="icon">
                    <use xlink:href="#icon-license"></use>
                </svg>
                The package distributed under license <em>GPL-2</em>. You are free to download and use this software for personal or commercial purposes.
            </p>

            <blockquote class="iconized">
                <svg class="icon">
                    <use xlink:href="#icon-info"></use>
                </svg>
                If you are a developer, please see the <em><?php echo $folder ?>Application.php</em> file and its template <em><?php echo $folder . $filename ?></em> to understand how this framework works.
            </blockquote>

            <nav>
            </nav>

            <footer>
                Yours sincerely,<br>
                the MiMiMi author
            </footer>
        </main>

        <?php
            if ( ! getSession ( 'noAnalysis' ) ) { ?>
                <aside>
                    <svg>
                        <use xlink:href="#icon-settings"></use>
                    </svg>
                    <div>
                        <strong>GDPR notice</strong>
                        Our website tracks the visitor's IP address, hostname, and browser agent to inform our manager about the presence of a live person on the website. This is the only element of your personal data that we currently analyze. If you object to this analysis, please click the button below.
                    </div>
                    <button>Disable analysis</button>
                </aside> <?php
            }
        ?>

        <footer>
            <p>&copy; <?php echo date('Y') ?> HelloWorld Example</p>
            <menu>
                <a href="https://mimimi.software/" rel="nofollow">Powered by MiMiMi</a>
                <a href="https://flaticon.com/"    rel="nofollow">Icons by FlatIcon</a>
            </menu>
        </footer>

        <script>
            <?php mimimiDump ( 'js/script.js', TRUE ) ?>
        </script>
    </body>
</html>
