<?php
/**
 * -------------------------------------------------------------------------
 *
 * STAGE 2: According to the development plan described in the comments of
 *          the "newspaper/Application.php" file, the second stage would be
 *          programming a module for parsing segments of the requested URL.
 *          This stage will consist of three steps: declaring the required
 *          class, writing a method to retrieve the editing command if it
 *          exists in the URL, writing a method to remove this command from
 *          the URL.
 *
 *          Please note that, in principle, you could skip this stage if you
 *          were using the base module "mimimi.modules/Url/Url.php", which
 *          already has similar methods. We left this stage only to show how
 *          development happens when conditions require writing each module
 *          yourself.
 *
 * -------------------------------------------------------------------------
 *
 * STEP 1:  First, you need to connect the base module using the directive
 *          "mimimiInclude". Then you should declare a class "MyMimimiUrl"
 *          which extends the base module class. Next, you should follow
 *          STEP 2 and STEP 3 detailed below to program this module.
 *
 * -------------------------------------------------------------------------
 *
 * @license  GPL-2.0  https://opensource.org/license/gpl-2-0/
 * @author   MiMiMi Community
 *
 * -------------------------------------------------------------------------
 */

mimimiInclude( 'Module.php' );
class MyMimimiUrl extends MimimiModule {

    /**
     * ---------------------------------------------------------------------
     *
     * STEP 2: You should declare and implement a public method to parse the
     *         requested URL and extract the edit command name, which may be
     *         optional and is usually found at the end of the URL. Please
     *         note that the name of this command is always returned in
     *         lowercase.
     *
     * ---------------------------------------------------------------------
     *
     * @public
     * @param   string  $url  Address of the requested page.
     * @return  string        The resulting command name (in lowercase).
     *
     * ---------------------------------------------------------------------
     */

    public function parseCommand ( $url ) {
        $command = preg_replace( '~^.*?([^/\\\\]+)$~us', '$1', $url );
        return mb_strtolower( $command, 'UTF-8' );
    }

    /**
     * ---------------------------------------------------------------------
     *
     * STEP 3: Finally, you should declare and implement a public method to
     *         remove the edit command name from the requested URL.
     *
     * ---------------------------------------------------------------------
     *
     * @public
     * @param   string  $url  Address of the requested page.
     * @return  string        Same URL without the command at the end of the URL.
     *
     * ---------------------------------------------------------------------
     */

    public function removeCommand ( $url ) {
        return preg_replace( '~[/\\\\]*[^/\\\\]+$~u', '', $url );
    }
};

/**
 * -------------------------------------------------------------------------
 *
 * It's great! You should now examine the "newspaper/Settings/Settings.php"
 * file that implements STAGE 3.
 *
 * -------------------------------------------------------------------------
 */