<?php
/**
 * -------------------------------------------------------------------------
 *
 * The module to provide specific routines for website themes.
 *
 * -------------------------------------------------------------------------
 *
 * @package    MimimiFramework
 * @subpackage Examples / Tiny News Feed site
 * @license    GPL-2.0
 *             https://opensource.org/license/gpl-2-0/
 * @copyright  2022 MiMiMi Community
 *             https://mimimi.software/
 *
 * -------------------------------------------------------------------------
 */

                                                        // -----------------
mimimiInclude(                                          // load a file              ( see file mimimi.core/Routines.php         -> mimimiInclude )
    'Helper/Helper.php'                                 // . . with this base class ( see file mimimi.modules/Helper/Helper.php -> MimimiHelper )
);                                                      //
                                                        // -----------------
class MyMimimiHelper extends MimimiModule {             // define required "My..." class for this module named HELPER
};                                                      // -----------------

/**
 * -------------------------------------------------------------------------
 *
 * Retrieves the breadcrumb node name.
 *
 * -------------------------------------------------------------------------
 *
 * @public
 * @param   string  $node  (optional) The viewer name associated with this node.
 * @return  string
 *
 * -------------------------------------------------------------------------
 */

function tinyGetBreadcrumb ( $node = '' ) {             // -----------------
    $def = isset(TINYFEED_INTERFACE_BREADCRUMBS['*'])   // get a default name ( see file tiny.news.feed/Constants.php -> TINYFEED_INTERFACE_BREADCRUMBS )
                 ? TINYFEED_INTERFACE_BREADCRUMBS['*']  // . . from this array item
                 : '';                                  // . . otherwise none
    return isset(TINYFEED_INTERFACE_BREADCRUMBS[$node]) // return a node name
                 ? TINYFEED_INTERFACE_BREADCRUMBS[$node]// . . from this array item
                 : $def;                                // . . otherwise default name
};                                                      // -----------------

/**
 * -------------------------------------------------------------------------
 *
 * Prints the page URL.
 *
 * -------------------------------------------------------------------------
 *
 * @public
 * @param   array  $row  The page record fetched from the database.
 * @return  void
 *
 * -------------------------------------------------------------------------
 */

function tinyPrintUrl ( $row ) {                        // -----------------
    printSiteUrl();                                     // print the site URL               ( like "htpps://your.site/" )
    printItemField('prefix', $row);                     //       plus a viewer name segment ( like "news/"              )
    printItemField('url',    $row);                     //       plus an URL path           ( like "some-news-url"      )
};                                                      // -----------------

/**
 * -------------------------------------------------------------------------
 *
 * Prints the class name of the page state if it's disabled.
 *
 * -------------------------------------------------------------------------
 *
 * @public
 * @param   array  $row  The page record fetched from the database.
 * @return  void
 *
 * -------------------------------------------------------------------------
 */

function tinyPrintState ( $row ) {                      // -----------------
    $value = empty($row['enabled'])                     // build a class name
                   ? 'moderating'                       // . . when page is disabled
                   : '';                                // . . when page is enabled
    printValue($value);                                 // print this class ( see file mimimi.modules/Helper/Helper.php -> printValue )
};                                                      // -----------------

/**
 * -------------------------------------------------------------------------
 *
 * Prints the attribute of Robots meta tag.
 *
 * -------------------------------------------------------------------------
 *
 * @public
 * @param   array  $row  The page record fetched from the database.
 * @return  void
 *
 * -------------------------------------------------------------------------
 */

function tinyPrintRobots ( $row ) {                     // -----------------
    $ok = ! empty($row['enabled']) &&                   // check if this page is for crawlers
          ! empty($row['body']) &&                      //
          ! empty($row['meta']) &&                      //
          ! empty($row['title']);                       //
                                                        // -----------------
    printValue($ok ? 'index, follow'                    // print an attribute
                   : 'noindex, nofollow');              //
};                                                      // -----------------

/**
 * -------------------------------------------------------------------------
 *
 * Sanitizes the HTML text.
 *
 * -------------------------------------------------------------------------
 *
 * @public
 * @param   string  $html  HTML text to be sanitized.
 * @return  string
 *
 * -------------------------------------------------------------------------
 */

function tinySanitize ( $html ) {                       // -----------------
                                                        // remove comments
    $html = preg_replace('~\s*<!--.*?-->\s*~us', ' ', $html);
    $html = preg_replace('~\s*<!--.*$~us',       '',  $html);
                                                        // -----------------
                                                        // remove scripts
    $html = preg_replace('~\s*<\?.*?\?>\s*~us',  ' ', $html);
    $html = preg_replace('~\s*<\?.*$~us',        '',  $html);
                                                        // -----------------
                                                        // remove tag attributes except <a href="something"> and <img src="something">
    $html = preg_replace('~<(a|img)_[^>]*>~ui',                   '<$1>',     $html);
    $html = preg_replace('~<a\s+(href=["\'][^"\'>]+["\'])~ui',    '<a_$1',    $html);
    $html = preg_replace('~<img\s+(src=["\'][^"\'>]+["\'])~ui',   '<img_$1',  $html);
    $html = preg_replace('~<((a|img)_[^\s>]+)(\s[^>]*)?>~ui',     '<$1>',     $html);
    $html = preg_replace('~<(/?[a-z][a-z0-9]*)([\s/][^>]*)?>~ui', '<$1>',     $html);
    $html = preg_replace('~<a_([^>]*)>~ui',                       '<a $1 rel="nofollow noopener noreferrer">',       $html);
    $html = preg_replace('~<img_([^>]*)>~ui',                     '<img $1 alt="" loading="lazy" decoding="async">', $html);
                                                        // -----------------
                                                        // remove an empty tags
    $html = preg_replace('~<([a-z][a-z0-9]*)>\s*</\1>~ui', ' ', $html);
                                                        // -----------------
                                                        // remove a broken tags
    $html = preg_replace('~\s*</?[a-z][a-z0-9]*[^>]*?$~us', '',  $html);
                                                        // -----------------
                                                        // remove an empty lines
    $html = preg_replace('~[ \t]+([\r\n])~u', '$1',   $html);
    $html = preg_replace('~[\r\n]+~u',        "\r\n", $html);
                                                        // -----------------
    $html = preg_replace('~(^\s+|\s+$)~u', '', $html);  // remove leading and trailing spaces
                                                        // -----------------
    return $html;                                       // return sanitized text
};                                                      // -----------------
