<?php
/**
 * -------------------------------------------------------------------------
 *
 * The module for working with website themes.
 *
 * -------------------------------------------------------------------------
 *
 * @package    MimimiFramework
 * @subpackage Examples / Tiny News Feed site
 * @license    GPL-2.0
 *             https://opensource.org/license/gpl-2-0/
 * @copyright  2022 MiMiMi Community
 *             https://mimimi.software/
 *
 * -------------------------------------------------------------------------
 */

                                                        // -----------------
mimimiInclude(                                          // load a file              ( see file mimimi.core/Routines.php -> mimimiInclude )
    'Module.php'                                        // . . with this base class ( see file mimimi.core/Module.php   -> MimimiModule )
);                                                      //
                                                        // -----------------
class MyMimimiThemes extends MimimiModule {             // define required "My..." class for this module

    /**
     * ---------------------------------------------------------------------
     *
     * Checks for the existence of the template file.
     *
     * ---------------------------------------------------------------------
     *
     * @public
     * @param   string  $file  Name of the template file to be checked.
     * @return  bool
     *
     * ---------------------------------------------------------------------
     */

    public function checkFor ( $file ) {                // -----------------
        $path  = dirname(__FILE__) . '/';               // get path to the themes folder
        $theme = MIMIMI_APP_THEME  . '/';               // get subfolder of the current theme ( see file tiny.news.feed/Config.php -> MIMIMI_APP_THEME )
        return file_exists($path . $theme . $file);     // check the presence of that file
    }                                                   // -----------------

    /**
     * ---------------------------------------------------------------------
     *
     * Renders the page according to the template.
     *
     * ---------------------------------------------------------------------
     *
     * First, we check that the filename is specified. Then we check the
     * presence of this file in the folder of the website current theme.
     * We then launch the HELPER module, which contains specific "<TAG>"
     * routines for this app themes. Next, we render the requested template
     * file from the current theme.
     *
     * ---------------------------------------------------------------------
     *
     * @public
     * @param   string  $file  Name of the template file to be rendered.
     * @return  void
     *
     * ---------------------------------------------------------------------
     */

    public function render ( $file ) {                  // -----------------
        if ( $file ) {                                  // if file name is specified
            $ok = $this->checkFor($file);               //     find it
            if ( $ok ) {                                //     if it is found
                                                        // -----------------
                $ok = $this                             //         check if this app has the required module installed
                      ->app                             //         . . via APPLICATION module ( see file tiny.news.feed/Application.php )
                      ->has                             //         . . via HAS module         ( see file mimimi.core/Has/Has.php -> __get )
                      ->helper;                         //         . . check for this module  ( see file tiny.news.feed/Helper/Helper.php )
                if ( $ok ) {                            //         if it's true
                                                        // -----------------
                    $this                               //             launch it
                    ->app                               //             . . via APPLICATION module ( see file tiny.news.feed/Application.php )
                    ->helper                            //             . . via HELPER module      ( see file tiny.news.feed/Helper/Helper.php -> run )
                    ->run();                            //             . . using this method
                }                                       //
                                                        // -----------------
                mimimiModule($file);                    //         render the template ( see file mimimi.core/Routines.php -> mimimiModule )
            }                                           //
        }                                               //
    }                                                   // -----------------
};