<?php
/**
 * -------------------------------------------------------------------------
 *
 * The snippet for rendering the More button and an administrative tools.
 *
 * -------------------------------------------------------------------------
 *
 * These system variables are available:
 *
 *     $params   = the current publication                   ( see file tiny.news.feed/Themes/default/card-*.tpl )
 *     $app      = your application                          ( see file mimimi.core/Routines.php -> mimimiInclude -> $app )
 *     $folder   = relative path of the application's folder ( see file mimimi.core/Routines.php -> mimimiInclude -> $folder )
 *     $filename = relative path of this TPL file            ( see file mimimi.core/Routines.php -> mimimiInclude -> $filename )
 *     $file     = absolute path of this TPL file            ( see file mimimi.core/Routines.php -> mimimiInclude -> $file )
 *
 * -------------------------------------------------------------------------
 *
 * @package    MimimiFramework
 * @subpackage Examples / Tiny News Feed site
 * @license    GPL-2.0
 *             https://opensource.org/license/gpl-2-0/
 * @copyright  2022 MiMiMi Community
 *             https://mimimi.software/
 *
 * -------------------------------------------------------------------------
 */

                                                        // -----------------
    $okEdit = $app->amIAdmin();                         // am I admin? ( see file tiny.news.feed/Application.php -> amIAdmin )
    $okText = ! empty($params['body'])                  // check if this publication contains full text
             && is_string($params['body']);             //
                                                        // -----------------
    if ( $okEdit || $okText ) {                         // if anything is true
        $subclass = $okText ? ''                        //     define related class
                            : 'no-more';                //

        /**
         * -----------------------------------------------------------------
         *
         * The More button.
         *
         * -----------------------------------------------------------------
         */

        ?>
        <nav class="menu <?php printValue($subclass) ?>">
            <?php                                       // -----------------
                if ( $okText ) {                        //     if this publication contains full text
                    ?>
                    <a class="btn more" href="<?php tinyPrintUrl($params) ?>">
                        <?php printValue(TINYFEED_INTERFACE_READMORE) ?>
                    </a>
                    <?php                               //
                }                                       // -----------------

                /**
                 * ---------------------------------------------------------
                 *
                 * Administrative tools.
                 *
                 * ---------------------------------------------------------
                 */

                                                        // -----------------
                if ( $okEdit ) {                        //     if I'm an admin
                    ?>
                    <a class="btn tools edit"   href="<?php tinyPrintUrl($params) ?>/edit"   rel="nofollow">
                        <?php printValue(TINYFEED_INTERFACE_EDIT) ?>
                    </a>

                    <a class="btn tools delete" href="<?php tinyPrintUrl($params) ?>/delete" rel="nofollow">
                        <?php printValue(TINYFEED_INTERFACE_DELETE) ?>
                    </a>
                    <?php                               //
                }                                       //
            ?>
        </nav>
        <?php                                           //
    }                                                   //
                                                        // -----------------
