<?php
/**
 * -------------------------------------------------------------------------
 *
 * Template for JSONing of the current customer entry.
 *
 * -------------------------------------------------------------------------
 *
 * These global variables are available:
 *
 *     $app    = your application
 *     $params = database entry retrieved by the "Customers" module
 *
 * -------------------------------------------------------------------------
 */

    sendHeaderJSON    (   );
    sendStatus200     (   );
    sendHeaderExpires ( 0 );
    stopIfHead        (   );

    /**
     * ---------------------------------------------------------------------
     *
     * Generate JSON if an authorized customer exists.
     *
     * ---------------------------------------------------------------------
     *
     * It is very important to pass a minimum of data to the client side.
     * This minimum will not allow the customer's personal data to be
     * accidentally disclosed, so we collect only the necessary entry
     * columns in JSON.
     *
     * ---------------------------------------------------------------------
     */

    echo json_encode (
             $params ? [ 'id'      => $params[ 'id'      ],
                         'name'    => $params[ 'name'    ],
                         'address' => $params[ 'address' ] ]

                        /**
                         * -------------------------------------------------
                         *
                         * JSON if no customer.
                         *
                         * -------------------------------------------------
                         */


                     : [ 'id'      => 0  ,
                         'name'    => '' ,
                         'address' => '' ]
         );
