<?php
/**
 * -------------------------------------------------------------------------
 *
 * The poller module for requesting data via the API. It is always called
 * using run() method implemented below. The initiator of that call is the
 * main module of your application.
 *
 * -------------------------------------------------------------------------
 *
 * @package    MimimiFramework
 * @subpackage Examples / Five Viewers site
 * @license    GPL-2.0
 *             https://opensource.org/license/gpl-2-0/
 * @copyright  2022 MiMiMi Community
 *             https://mimimi.software/
 *
 * -------------------------------------------------------------------------
 */

    mimimiInclude ( 'Module.php' );
    class MyMimimiApi extends MimimiModule {

        /**
         * -----------------------------------------------------------------
         *
         * Sends a result of the current request.
         *
         * -----------------------------------------------------------------
         *
         * Please note that due to the specifics of the app's router, this
         * method of the poller module "Api" is called for any URLs starting
         * with "polls/api". However, currently only two forms of URL are
         * processed by this method:
         *
         *     https://your.site/polls/api/v1/random
         *     https://your.site/polls/api/v1/random/from/CHANNEL-ID
         *                                 │                       │
         *                                 └──────────┬────────────┘
         *                                            │
         *                                            └─> it is the incoming $params
         *
         * Another forms of the locator are incorrect and are therefore
         * ignored, causing the app's router to display them later using the
         * visual module "Error404". This is what those incorrect forms look
         * like:
         *
         *     https://your.site/polls/api
         *     https://your.site/polls/api/v1
         *     https://your.site/polls/api/v1/random
         *     https://your.site/polls/api/v1/random/UNDEFINED-OPTIONS
         *     https://your.site/polls/api/UNDEFINED-VERSION
         *     https://your.site/polls/api/UNDEFINED-VERSION/UNDEFINED-COMMAND
         *     https://your.site/polls/api/UNDEFINED-VERSION/UNDEFINED-COMMAND/UNDEFINED-OPTIONS
         *
         * -----------------------------------------------------------------
         *
         * @public
         * @param   mixed  $params  (optional) The rest of page's URL if detected by the app's routing method.
         * @return  bool            TRUE  if the result was sent successfully.
         *                          FALSE if the page URL is incorrect and an Error404 page needs to be displayed.
         *
         * -----------------------------------------------------------------
         */

        public function run ( $params = '' ) {
            $version = $this->app->cutUrlSegment ( $params );
            switch ( $version ) {
                case 'v1': return $this->routeVersion1 ( $params );
            }
            return FALSE;
        }

        /**
         * -----------------------------------------------------------------
         *
         * Processes a request for API version 1.
         *
         * -----------------------------------------------------------------
         *
         * This method parses the URL for a matching command, and if it
         * finds one, sends the rest of the URL to the appropriate handler.
         *
         * In this example, the following URLs correspond to these commands:
         *
         *     https://your.site/polls/api/v1/random
         *     https://your.site/polls/api/v1/random/REST-OF-URL
         *                                    │                │
         *                                    └───────┬────────┘
         *                                            │
         *                                            └─> it is the incoming $url
         *
         * -----------------------------------------------------------------
         *
         * @protected
         * @param   string  $url  The rest of page's URL containing a command and its options.
         * @return  bool          TRUE  if the result was sent successfully.
         *                        FALSE if the command is incorrect and an Error404 page needs to be displayed.
         *
         * -----------------------------------------------------------------
         */

        protected function routeVersion1 ( $url ) {
            $command = $this->app->cutUrlSegment ( $url );
            switch ( $command ) {
                case 'random':  return $this->doRandomVersion1  ( $url );
            }
            return FALSE;
        }

        /**
         * -----------------------------------------------------------------
         *
         * Executes the "Random" command for API version 1.
         *
         * -----------------------------------------------------------------
         *
         * This method handles the following URLs:
         *
         *     https://your.site/polls/api/v1/random
         *     https://your.site/polls/api/v1/random/from/CHANNEL-ID
         *                                           │             │
         *                                           └──────┬──────┘
         *                                                  │
         *                                                  └─> it is the incoming $options
         *
         * -----------------------------------------------------------------
         *
         * @protected
         * @param   string  $options  The rest of page's URL containing the command options.
         * @return  bool              TRUE  if the result was sent successfully.
         *                            FALSE if the options are incorrect and an Error404 page needs to be displayed.
         *
         * -----------------------------------------------------------------
         */

        protected function doRandomVersion1 ( $options ) {
            $target = $this->app->cutUrlSegment ( $options );
            switch ( $target ) {
                case 'from':
                     if ( $options == '' ) break;
                case '':
                     $this->sendJsonHeaders (        );
                              $this->app->channels->install             (          );
                     $entry = $this->app->channels->messages->getRandom ( $options );
                     $this->sendJsonData    ( $entry );
                     return TRUE;
            }
            return FALSE;
        }

        /**
         * -----------------------------------------------------------------
         *
         * Sends JSON headers.
         *
         * -----------------------------------------------------------------
         *
         * @protected
         * @return  void
         *
         * -----------------------------------------------------------------
         */

        protected function sendJsonHeaders ( ) {
            $this->app->runHelper (   );
            sendHeaderJSON        (   );
            sendStatus200         (   );
            sendHeaderExpires     ( 0 );
            stopIfHead            (   );
        }

        /**
         * -----------------------------------------------------------------
         *
         * Sends a JSON response.
         *
         * -----------------------------------------------------------------
         *
         * @protected
         * @param   array  $data  Items to be sent to the browser.
         * @return  void
         *
         * -----------------------------------------------------------------
         */

        protected function sendJsonData ( $data ) {
            echo $data
                 ? json_encode ( $data )
                 : '{}';
        }
    };
