<?php
/**
 * -------------------------------------------------------------------------
 *
 * The viewer module for generating a "robots.txt" document. It is always
 * called using run() method implemented below. The initiator of that call
 * is the main module of your application.
 *
 * -------------------------------------------------------------------------
 *
 * @package    MimimiFramework
 * @subpackage Examples / Five Viewers site
 * @license    GPL-2.0
 *             https://opensource.org/license/gpl-2-0/
 * @copyright  2022 MiMiMi Community
 *             https://mimimi.software/
 *
 * -------------------------------------------------------------------------
 */

    mimimiInclude ( 'Module.php' );
    class MyMimimiRobotsTxt extends MimimiModule {

        /**
         * -----------------------------------------------------------------
         *
         * Generates the contents of ROBOTS document.
         *
         * -----------------------------------------------------------------
         *
         * Please note that due to the specifics of the app's router, this
         * method of the visual module "RobotsTxt" is called for any URLs
         * starting with "robots.txt". However, only a single form of URL is
         * processed by this method:
         *
         *     https://your.site/robots.txt
         *
         * Another forms of the locator are incorrect and are therefore
         * ignored, causing the app's router to display them later using the
         * visual module "Error404". This is what those incorrect forms look
         * like:
         *
         *     https://your.site/robots.txt/UNDEFINED-OPTIONS
         *                                  │               │
         *                                  └──────┬────────┘
         *                                         │
         *                                         └─> it is the incoming $params
         *
         * -----------------------------------------------------------------
         *
         * @public
         * @param   mixed  $params  (optional) The rest of page's URL if detected by the app's routing method.
         * @return  bool            TRUE  if the document was rendered successfully.
         *                          FALSE if the page URL is incorrect and an Error404 page needs to be displayed.
         *
         * -----------------------------------------------------------------
         */

        public function run ( $params = '' ) {
            return $params == ''
                && $this->app->renderTemplate ( 'robots-txt.tpl',
                                                'Oops, this site does not have a "robots.txt" template!' );
        }
    };
