<?php
    sendHeaderHTML ( );

    $database = dirname ( $file ) . '/todo.json';

    /**
     * ---------------------------------------------------------------------
     *
     * If the input form was submitted and we are not in demo mode.
     *
     * ---------------------------------------------------------------------
     */

    $error = '';
    if ( getFormInput ( 'submit' ) ) {
        if ( helperHasProduction ( ) ) {

            /**
             * -------------------------------------------------------------
             *
             * If at least one task is submitted.
             *
             * -------------------------------------------------------------
             */

            $data = [ ];
            $items = mimimiPost ( 'task' );
            if ( $items ) {

                /**
                 * ---------------------------------------------------------
                 *
                 * If at least one task is submitted.
                 *
                 * ---------------------------------------------------------
                 */

                $states = mimimiPost ( 'done' );

                /**
                 * ---------------------------------------------------------
                 *
                 * Go through these tasks.
                 *
                 * ---------------------------------------------------------
                 */

                foreach ( $items as $index => $task ) {

                    /**
                     * -----------------------------------------------------
                     *
                     * If the task is really entered.
                     *
                     * -----------------------------------------------------
                     */

                    $task = preg_replace ( '~(^\s+|\s+$)~u', '', $task );
                    if ( $task ) {

                        /**
                         * -------------------------------------------------
                         *
                         * Add the task to save later.
                         *
                         * -------------------------------------------------
                         */

                        $data[ ] = [
                            'task' => $task,
                            'done' => ! empty ( $states[ $index ] )
                        ];
                    }
                }
            }

            /**
             * -------------------------------------------------------------
             *
             * Save tasks.
             *
             * -------------------------------------------------------------
             */

            $data = json_encode ( $data );
            @ file_put_contents ( $database, $data );

        /**
         * -----------------------------------------------------------------
         *
         * Otherwise, prepare an error message.
         *
         * -----------------------------------------------------------------
         */

        } else {
            $error = 'Sorry, you are currently in demo mode. Any editor operation is only simulated in this mode. To see how it really works, download this package and install it on your site or localhost.';
        }
    }

    /**
     * ---------------------------------------------------------------------
     *
     * Generate page content.
     *
     * ---------------------------------------------------------------------
     */

?><!DOCTYPE html>
<html lang="en">
    <head>
        <meta charset="UTF-8">
        <meta name="viewport" content="width=device-width, initial-scale=1">

        <meta name="robots" content="noindex, nofollow">
        <title>To Do example</title>

        <!--
         * -------------------------------------------------------------
         *
         * Load page styles (file specified relative to base directory).
         *
         * -------------------------------------------------------------
         -->

        <base href="<?php printSiteUrl ( ) ?>projects/todo/">
        <link href="todo.css" rel="stylesheet">
        <link href="favicon.png" type="image/png" rel="shortcut icon">
    </head>

    <body>
        <main>
            <h1>To Do example</h1>
            <p>Please enter a new task in the input box below and press "Add Task" button. Click a "Done" shortcut to toggle its row state, and then press "Save Changes" button. Click on a row's text line to expand it for easier reading.</p>

            <!--
             * -------------------------------------------------------------
             *
             * Display an error message if exists.
             *
             * -------------------------------------------------------------
             -->

            <p class="error"><?php printValue ( $error ) ?></p>

            <!--
             * -------------------------------------------------------------
             *
             * Display a new ToDo row.
             *
             * -------------------------------------------------------------
             -->

            <form class="items" method="post">
                <div class="item">
                    <input name="done[0]"
                           type="hidden"
                           value="0">
                    <textarea name="task[0]"
                              maxlength="500"
                              rows="1"></textarea>
                </div>

                <!--
                 * ---------------------------------------------------------
                 *
                 * Display a button to save the new row.
                 *
                 * ---------------------------------------------------------
                 -->

                <nav>
                    <button type="submit"
                            name="submit"
                            value="1">Add Task</button>
                    <a href="<?php printSiteUrl ( ) ?>" target="_top">Exit</a>
                </nav>

                <?php
                    /**
                     * -----------------------------------------------------
                     *
                     * Read tasks from the database file.
                     *
                     * -----------------------------------------------------
                     */

                    $data = @ file_get_contents ( $database );
                    $list = json_decode ( $data, TRUE );
                    if ( $list ) {

                        /**
                         * -------------------------------------------------
                         *
                         * Go through these tasks.
                         *
                         * -------------------------------------------------
                         */

                        $num = 0;
                        foreach ( $list as $entry ) {
                            $status = $entry[ 'done' ] ? 'checked' : '';
                            $num++;

                            /**
                             * ---------------------------------------------
                             *
                             * Display the ToDo row.
                             *
                             * ---------------------------------------------
                             */

                            ?>
                            <div class="item <?php printValue ( $status ) ?>">
                                <label>
                                    <input name="done[<?php printValue ( $num ) ?>]"
                                           type="checkbox"
                                           <?php printValue ( $status ) ?>
                                           value="1">
                                    Done
                                </label>

                                <textarea name="task[<?php printValue ( $num ) ?>]"
                                          rows="1"
                                          readonly
                                          tabindex="-1"><?php printValue ( $entry[ 'task' ] ) ?></textarea>
                            </div>
                            <?php
                        }

                        /**
                         * -------------------------------------------------
                         *
                         * Display a button to save changes made to rows.
                         *
                         * -------------------------------------------------
                         */

                        ?>
                        <nav>
                            <button class="save"
                                    type="submit"
                                    name="submit"
                                    value="1"
                                    disabled>Save Changes</button>
                        </nav>
                        <?php
                    }
                ?>
            </form>
        </main>
        <script src="todo.js"></script>
    </body>
</html>