let changeCount = 0;

const toggleSaveButton = ( input ) => {
    const form = input.closest ( 'form' );
    if ( form ) {
        const btn = form.querySelector ( '.save' );
        if ( btn ) {
            if ( changeCount > 0 ) btn.removeAttribute ( 'disabled'             )
                              else btn.setAttribute    ( 'disabled', 'disabled' );
        }
    }
};

const toggleDone = ( event ) => {
    const input = event.target,
          item  = input.closest ( '.item' );
    if ( item ) {
        if ( input.checked ) item.classList.add    ( 'checked' )
                        else item.classList.remove ( 'checked' );
        changeCount += input.checked != input.defaultChecked
                                     ?  1
                                     : -1;
        toggleSaveButton ( input );
    }
};

const inputs = document.querySelectorAll ( 'input[type="checkbox"]' );
inputs.forEach (
    ( input ) => input.onchange = toggleDone
);
