<?php
/**
 * -------------------------------------------------------------------------
 *
 * Snippet for rendering the contents of the page "Topmenu -> File -> Save File".
 *
 * -------------------------------------------------------------------------
 *
 * These global variables are available:
 *
 *     $app  = your application
 *     $item = relative URL of the file that will be saved
 *
 * -------------------------------------------------------------------------
 */

    /**
     * ---------------------------------------------------------------------
     *
     * Execute a server logic according to the type of the current page.
     *
     * ---------------------------------------------------------------------
     */

    $data = $app->projects->getProject ( );

    global $item;

    $error     = '';
    $success   = '';
    $extension = '.' . preg_replace ( '~\|~u'                  ,
                                      ', .'                    ,
                                      helperFileExtensions ( ) );
    $screen    = 1;

    /**
     * ---------------------------------------------------------------------
     *
     * If the input form was submitted.
     *
     * ---------------------------------------------------------------------
     */

    if ( getFormInput ( 'submit' ) ) {

        /**
         * -----------------------------------------------------------------
         *
         * Get the entered file path and name.
         *
         * -----------------------------------------------------------------
         */

        $file = mimimiSafePath ( $item, TRUE );
        if ( $file ) {

            /**
             * -------------------------------------------------------------
             *
             * It must be alphanumeric path and file name.
             *
             * -------------------------------------------------------------
             */

            if ( preg_match ( helperFilePattern ( ), $file ) ) {

                /**
                 * ---------------------------------------------------------
                 *
                 * It must exist.
                 *
                 * ---------------------------------------------------------
                 */

                if ( helperHasFile ( $file ) ) {

                    /**
                     * -----------------------------------------------------
                     *
                     * Its body must be presented.
                     *
                     * -----------------------------------------------------
                     */

                    $body = mimimiPost ( 'body', FALSE );
                    if ( is_string ( $body ) ) {

                        /**
                         * -------------------------------------------------
                         *
                         * Save the project file.
                         *
                         * -------------------------------------------------
                         */

                        if ( helperHasProduction ( ) ) {
                            helperCreateFile ( $file, $body );
                            $screen = 2;

                        /**
                         * -------------------------------------------------
                         *
                         * Otherwise, prepare an error message.
                         *
                         * -------------------------------------------------
                         */

                        } else {
                            $success = 'Sorry, you are currently in demo mode. Any create/add/edit/delete operation is only simulated in this mode. To see how it really works, download this package and install it on your site or localhost.';
                        }
                    } else {
                        $error = 'The data sent in this request must contain the body of the file you want to save.';
                    }
                } else {
                    $error = 'Sorry, the current project does not contain a file with the same name.';
                }
            } else {
                $error = 'The path and file name can only contain alphanumeric characters, hyphens, underscores, and periods. Path segments must be separated by slashes. The file name must have a valid extension: ' . $extension . '.';
            }
        } else {
            $error = 'The URL must contain the name of the file you want to save.';
        }
    } else {
        $error = 'This request must contain the data for the file you want to save.';
    }

    /**
     * ---------------------------------------------------------------------
     *
     * Generate snippet content.
     *
     * ---------------------------------------------------------------------
     */

    switch ( $screen ) {

        /**
         * -----------------------------------------------------------------
         *
         * On the first screen, we display the error message if exists.
         *
         * -----------------------------------------------------------------
         */

        case 1:
             ?>
             <div class="modal">
                 <div class="error"  ><?php printValue ( $error   ) ?></div>
                 <div class="success"><?php printValue ( $success ) ?></div>

                 <h1>Save File</h1>
                 <p>You are currently trying to save the <code><?php printValue ( $item ) ?></code> file located in the current project <code><?php printValue ( $data[ 'dir' ] ) ?></code>.</p>

                 <footer class="buttons">
                     <button class="btn" onclick="app.closeWindow ( this )">CLOSE</button>
                 </footer>
             </div>
            <?php
            break;

        /**
         * -----------------------------------------------------------------
         *
         * On the second screen, we just redirect the user to the home page.
         *
         * -----------------------------------------------------------------
         */

        case 2:
        default:
             mimimiModule ( 'snippets/go-home.tpl' );
    }
